import os
import argparse
from maps.wikimap.stat.kpi.valuable_edits.valuable_categories.lib import valuable_categories


YT_PROXY = 'hahn'
ANALYTICS_PATH = '//home/maps/core/nmaps/analytics/'
VALUABLE_CATEGORIES_TABLE = 'geo-data/valuable_categories'


def register_command(subparsers, name, help):
    parser = subparsers.add_parser(name, help=help)
    parser.set_defaults(command=name)
    parser.add_argument('category_groups', help='Local path to category_groups.xml')
    return parser


def register_print_command(subparsers):
    register_command(subparsers, 'print', 'Print mapping to stdout')


def register_upload_command(subparsers):
    parser = register_command(subparsers, 'upload', 'Upload results to yt')

    parser.add_argument('--token', help='Overrides YT_TOKEN and yt config')
    parser.add_argument(
        '--proxy',
        help='Overrides YT_PROXY. If neither --proxy nor YT_PROXY is set, defaults to {}'.format(YT_PROXY),
        default=os.environ['YT_PROXY'] if 'YT_PROXY' in os.environ else YT_PROXY
    )

    output_group = parser.add_mutually_exclusive_group()
    output_group.add_argument(
        '--analytics',
        help='Nmaps-Analytics path on yt. Here is used solely for ${{results}} default value evaluation. Defaults to {}'.format(ANALYTICS_PATH),
        default=ANALYTICS_PATH
    )
    output_group.add_argument(
        '--results',
        help='Destination path on yt cluster. Defaults to ${{analytics}}/{}'.format(VALUABLE_CATEGORIES_TABLE)
    )


def make_parser():
    parser = argparse.ArgumentParser(
        description='Generates from category_groups.xml {{"{}": group_id, "{}": category_id}} '
        'pairs for ugc (user-generated content) categories. If category is {}, category_id is put '
        'both in group_id and in "{}" ugc group. Otherwise, in "{}" only.'.format(
            valuable_categories.GROUP_COL,
            valuable_categories.CATEGORY_COL,
            valuable_categories.VALUABLE_ATTR_NAME,
            valuable_categories.VALUABLE_GROUP_ID,
            valuable_categories.NOT_VALUABLE_GROUP_ID
        )
    )

    subparsers = parser.add_subparsers(help='Either upload to yt or print')
    register_print_command(subparsers)
    register_upload_command(subparsers)

    return parser


def eval_results_path(args):
    if args.results is None:
        return os.path.join(args.analytics, VALUABLE_CATEGORIES_TABLE)
    return args.results
