import pytest
import os
import json
import yt.wrapper as yt
from maps.wikimap.stat.kpi.valuable_edits.valuable_categories.lib.valuable_categories import upload


@pytest.fixture
def client():
    return yt.YtClient(proxy=os.environ['YT_PROXY'])


def test_create_table(client):
    table = '//tmp/create_table'

    correct_input = [{'category_group': 'not_valuable', 'object_category': 'hydro_el'}]
    upload(correct_input, client, table)

    output = client.read_table(table, format='json')
    assert sorted(correct_input) == sorted(output)


def test_overwrite_table(client):
    table = '//tmp/overwrite_table'

    first_input = [{'category_group': 'not_valuable', 'object_category': 'hydro_jc'}]
    second_input = [{'category_group': 'not_valuable', 'object_category': 'hydro_el'}]
    upload(first_input, client, table)
    upload(second_input, client, table)

    output = client.read_table(table, format='json')
    assert sorted(second_input) == sorted(output)


def test_default_schema_is_correct(client):
    table = '//tmp/default_schema_is_correct'

    empty_input = []
    upload(empty_input, client, table)

    schema = json.loads(client.get(os.path.join(table, '@schema'), format='json'))
    assert ['category_group', 'object_category'] == sorted([field['name'] for field in schema['$value']])
    assert all(field['required'] is True for field in schema['$value'])


def test_user_defined_schema(client):
    table = '//tmp/create_table'
    correct_input = [{'category_group': 3, 'object-category': 'hydro_el'}]
    schema = [
        {'name': 'category_group', 'type': 'uint64', 'required': True},
        {'name': 'object-category', 'type': 'utf8', 'required': True}
    ]

    upload(correct_input, client, table, schema)
    output = client.read_table(table, format='json')
    assert sorted(correct_input) == sorted(output)
