from collections import namedtuple
from nile.api.v1 import cli


LOGS_DEFAULT = '//home/logfeller/logs'
ANALYTICS_DEFAULT = '//home/maps/core/nmaps/analytics'
AGG_SCALE_DEFAULT = 'd'

AGG_SCALE_CHOICES = ['d', 'w', 'm']


def logs_option():
    return cli.Option(
        'logs',
        help='Yt path to logfeller logs. Defaults to {}'.format(LOGS_DEFAULT),
        default=LOGS_DEFAULT
    )


def analytics_option():
    return cli.Option(
        'analytics',
        help='Yt path to maps-nmaps analytics. Defaults to {}'.format(ANALYTICS_DEFAULT),
        default=ANALYTICS_DEFAULT
    )


def eval_results_default(options):
    """
        Evaluate results_path, when options.results is not specified.
        This implementation is used in results_option() and get_reults_path() by default.
    """
    return None


def results_option(eval_default=eval_results_default, *args):
    options = namedtuple('Options', args)(**{arg: '{{' + arg + '}}' for arg in args})
    return cli.Option(
        'results',
        help='Yt path (usually, path prefix) for results. Here, defaults to {}'.format(eval_default(options)),
        default=None
    )


def get_results_path(options, eval_default=eval_results_default):
    if options.results is None:
        return eval_default(options)
    return options.results


def agg_scale_option():
    return cli.Option(
        'agg_scale',
        help='Aggregation scale for dates (d, w, m, y). Defaults to d',
        choices=['d', 'w', 'm', 'y'],
        default='d'
    )


def users_dump_date_option():
    return cli.Option(
        'users-dump-date',
        help='Use specific date for users-dump-log'
    )


def get_single_date(options):
    OPTIONS_DATES_DEFAULT = '1970-01-01'

    if len(options.dates) > 1:
        raise ValueError('Expected single date in --dates option')

    if options.dates[0] == OPTIONS_DATES_DEFAULT:
        raise ValueError('Default value (i.e. {}) is not allowed for --dates option'.format(OPTIONS_DATES_DEFAULT))

    return options.dates[0]
