import datetime


def clear_old_tables(yt_client, path, store_time_minutes, logger):
    utcnow = datetime.datetime.utcnow()
    for table in yt_client.search(
        path,
        node_type=["table"],
        attributes=["creation_time"]
    ):
        table_creation_time = datetime.datetime.strptime(
            table.attributes.get('creation_time'),
            '%Y-%m-%dT%H:%M:%S.%fZ'
        )
        table_exp_time = table_creation_time + datetime.timedelta(minutes=store_time_minutes)

        if table_exp_time < utcnow:
            logger.info(
                "Dropping old table '{}'".format(table)
            )
            yt_client.remove(table)
