import pytest
from maps.wikimap.stat.libs.common.lib import dates as d


def test_none_isodate_error():
    with pytest.raises(TypeError, match='Expected bytes or unicode argument'):
        dates = list(d.aggregation_dates(None, 'w'))
        print(dates)


def test_none_scale_error():
    with pytest.raises(ValueError, match='got scale None \\(expected d, w, m or y\\)'):
        dates = list(d.aggregation_dates('2019-09-03', None))
        print(dates)


def test_bad_last_isodate_error():
    with pytest.raises(ValueError, match='wrong datetime \'201-09-03\':.+'):
        dates = list(d.aggregation_dates('201-09-03', 'w'))
        print(dates)


def test_invalid_scale_error():
    with pytest.raises(ValueError, match='got scale x \\(expected d, w, m or y\\)'):
        dates = list(d.aggregation_dates('2019-09-03', 'x'))
        print(dates)


def test_too_small_scale_error():
    with pytest.raises(ValueError, match='got scale h \\(expected d, w, m or y\\)'):
        dates = list(d.aggregation_dates('2019-09-03', 'h'))
        print(dates)


def test_d_scale():
    dates = list(d.aggregation_dates('2019-09-03', 'd'))
    assert dates == ['2019-09-03']


def test_w_scale():
    dates = list(d.aggregation_dates('2019-09-03', 'w'))
    assert dates == [
        '2019-08-28',
        '2019-08-29',
        '2019-08-30',
        '2019-08-31',
        '2019-09-01',
        '2019-09-02',
        '2019-09-03',
    ]


def test_m_scale():
    dates = list(d.aggregation_dates('2019-09-03', 'm'))
    assert dates == [
        '2019-08-07',
        '2019-08-08',
        '2019-08-09',
        '2019-08-10',
        '2019-08-11',
        '2019-08-12',
        '2019-08-13',
        '2019-08-14',
        '2019-08-15',
        '2019-08-16',
        '2019-08-17',
        '2019-08-18',
        '2019-08-19',
        '2019-08-20',
        '2019-08-21',
        '2019-08-22',
        '2019-08-23',
        '2019-08-24',
        '2019-08-25',
        '2019-08-26',
        '2019-08-27',
        '2019-08-28',
        '2019-08-29',
        '2019-08-30',
        '2019-08-31',
        '2019-09-01',
        '2019-09-02',
        '2019-09-03'
    ]


def test_y_scale():
    dates = list(d.aggregation_dates('2021-02-01', 'y'))
    assert dates == sorted(dates)
    assert all(len(date) == len('YYYY-MM-DD') for date in dates)
    assert len(dates) == 364
    assert dates[-1] == '2021-02-01'
    assert dates[0] == '2020-02-04'
