import pytest
from maps.wikimap.stat.libs.common.lib import dates as d


def test_none_isodate_error():
    with pytest.raises(TypeError, match='Expected bytes or unicode argument'):
        dates_str = d.aggregation_dates_str(None, 'w')
        print(dates_str)


def test_none_scale_error():
    with pytest.raises(ValueError, match='got scale None \(expected d, w, m or y\)'):
        dates_str = d.aggregation_dates_str('2019-09-03', None)
        print(dates_str)


def test_bad_last_isodate_error():
    with pytest.raises(ValueError, match='wrong datetime \'201-09-03\':.+'):
        dates_str = d.aggregation_dates_str('201-09-03', 'w')
        print(dates_str)


def test_invalid_scale_error():
    with pytest.raises(ValueError, match='got scale x \(expected d, w, m or y\)'):
        dates_str = d.aggregation_dates_str('2019-09-03', 'x')
        print(dates_str)


def test_too_small_scale_error():
    with pytest.raises(ValueError, match='got scale h \(expected d, w, m or y\)'):
        dates_str = d.aggregation_dates_str('2019-09-03', 'h')
        print(dates_str)


def test_d_scale():
    dates_str = d.aggregation_dates_str('2019-09-03', 'd')
    assert dates_str == '2019-09-03'


def test_w_scale():
    dates_str = d.aggregation_dates_str('2019-09-03', 'w')
    assert dates_str == '{2019-08-28..2019-09-03}'


def test_m_scale():
    dates = d.aggregation_dates_str('2019-09-03', 'm')
    assert dates == '{2019-08-07..2019-09-03}'


def test_y_scale():
    dates = d.aggregation_dates_str('2021-02-01', 'y')
    assert dates == '{2020-02-04..2021-02-01}'
