from datetime import datetime
from maps.wikimap.stat.libs.common.lib.datetime_interval import (
    DatetimeInterval,
    datetime_intervals_overlap,
)


def intervalFromTimestamp(t1, t2):
    return DatetimeInterval(
        datetime.utcfromtimestamp(t1),
        datetime.utcfromtimestamp(t2) if t2 is not None else None
    )


def test_simple_overlap():
    i1 = intervalFromTimestamp(1580200000, 1580210000)
    i2 = intervalFromTimestamp(1580205000, 1580220000)
    res = datetime_intervals_overlap(i1, i2)

    correct = intervalFromTimestamp(1580205000, 1580210000)
    assert res.to_string() == correct.to_string()


def test_infinity_overlap():
    i1 = intervalFromTimestamp(1580200000, None)
    i2 = intervalFromTimestamp(1580205000, None)
    res = datetime_intervals_overlap(i1, i2)

    correct = intervalFromTimestamp(1580205000, None)
    assert res.to_string() == correct.to_string()


def test_empty_overlap():
    i1 = intervalFromTimestamp(1580200000, 1580210000)
    res = datetime_intervals_overlap(i1, None)

    assert res is None
