import maps.wikimap.stat.libs.geobase_regions as gb
from yt.yson import to_yson_type


gb.init_geodata_from_resource()


def test_geo_coords_to_geobase_region():
    assert 120542 == gb.geo_coords_to_region_id(55.733684, 37.588496)
    assert gb.ATLANTIS_REGION_ID == gb.geo_coords_to_region_id(-100, 46.83710939)


def test_mercator_geom_to_geobase_region():
    assert 102159 == gb.mercator_geom_to_region_id(
        b'0103000020430D00000100000005000000D3DEE0E3A8EC464153CBD63ECEFC5A41D3DEE0E3A8EC46417B14AE51D6FC5A4'
        b'1EBAD81E9B6EC46417B14AE51D6FC5A41EBAD81E9B6EC464153CBD63ECEFC5A41D3DEE0E3A8EC464153CBD63ECEFC5A41'
    )
    assert gb.EARTH_REGION_ID == gb.mercator_geom_to_region_id(None)
    assert gb.ATLANTIS_REGION_ID == gb.mercator_geom_to_region_id(b'bad geom')


def test_lon_lat_position_to_geobase_region():
    assert 105951 == gb.lon_lat_position_to_region_id(to_yson_type([57.7339356755, 40.9039767299]))
    assert gb.EARTH_REGION_ID == gb.lon_lat_position_to_region_id(None)


def test_lon_lat_bbox_to_geobase_region():
    assert 120542 == gb.lon_lat_bbox_to_region_id(b'[[37.588496, 55.733684], [37.588496, 55.733684]]')
    assert gb.EARTH_REGION_ID == gb.lon_lat_bbox_to_region_id(None)
    assert gb.ATLANTIS_REGION_ID == gb.lon_lat_bbox_to_region_id(b'bad bbox')
