from maps.wikimap.stat.libs.nile_utils import ensure_str
import pytest


def test_ensure_str_should_preserve_none():
    assert ensure_str(None) is None


def test_ensure_str_should_preserve_str():
    assert ensure_str('abc') == 'abc'


def test_ensure_str_should_decode_bytes():
    assert ensure_str(b'abc') == 'abc'


def test_ensure_str_should_fail_if_not_bytes_or_str():
    with pytest.raises(AssertionError, match='Expected bytes or str'):
        ensure_str(123)
