def ensure_str(value):
    '''
    Convert `bytes` to `str`, if needed. Preserve `None`.
    '''
    if value is None:
        return None

    if isinstance(value, bytes):
        return value.decode()

    assert isinstance(value, str), f'Expected bytes or str, got {value}'
    return value
