import re
from maps.wikimap.stat.libs.nile_utils import ensure_str

_TRACKER_TASK_PREFIX = 'tracker'
_DISPATCHING_TASK_PREFIX = 'dispatching'


def _get_task_id(ticket, component, task_id_prefix):
    '''
    Converts ticket number (in form of QUEUE_NAME-XXX) and a component in a task id.
    '''
    queue = re.match('(.+)-\\d+', ensure_str(ticket)).group(1).lower()
    return '/'.join((task_id_prefix, queue, ensure_str(component)))


def get_tracker_task_id(ticket, component):
    return _get_task_id(ticket, component, _TRACKER_TASK_PREFIX)


def get_dispatching_task_id(ticket, component):
    return _get_task_id(ticket, component, _DISPATCHING_TASK_PREFIX)
