from maps.wikimap.stat.libs.tracker.lib.staff_uids import convert_staff_uid_to_puid
from maps.wikimap.stat.libs import nile_ut
from nile.api.v1 import Record


def test_should_convert_staff_uid_to_puid():
    result = nile_ut.yt_run(
        convert_staff_uid_to_puid,
        issues=nile_ut.Table([
            Record(staff_uid=1, component=b'component 1', ticket=b'ticket 11', story_points=11, date='2020-01-25'),
            Record(staff_uid=2, component=b'component 2', ticket=b'ticket 22', story_points=22, date='2020-01-25'),
            Record(staff_uid=1, component=b'component 1', ticket=b'ticket 12', story_points=12, date='2020-01-26'),
            Record(staff_uid=3, component=b'component 3', ticket=b'ticket 33', story_points=33, date='2020-01-25'),
        ]),
        linked_accounts=nile_ut.Table([
            Record(staff_uid=1, puid=11, test_field=b'other 11', is_primary_link=True, date='2020-01-25'),
            Record(staff_uid=1, puid=12, test_field=b'other 12', is_primary_link=True, date='2020-01-26'),
            Record(staff_uid=2, puid=22, test_field=b'other 22', is_primary_link=True, date='2020-01-25'),
            # staff_uid=3 is absent
            Record(staff_uid=4, puid=44, test_field=b'other 44', is_primary_link=True, date='2020-01-25'),
        ]),
    )
    assert sorted([
        Record(puid=11, component=b'component 1', ticket=b'ticket 11', story_points=11, date='2020-01-25'),
        Record(puid=22, component=b'component 2', ticket=b'ticket 22', story_points=22, date='2020-01-25'),
        Record(puid=12, component=b'component 1', ticket=b'ticket 12', story_points=12, date='2020-01-26'),
        Record(puid=3,  component=b'component 3', ticket=b'ticket 33', story_points=33, date='2020-01-25'),
    ]) == sorted(result)


def test_should_use_only_primary_puid_when_converting_staff_uid_to_puid():
    result = nile_ut.yt_run(
        convert_staff_uid_to_puid,
        issues=nile_ut.Table([
            Record(staff_uid=1, component=b'component', ticket=b'ticket', story_points=1, date=b'2020-01-25'),
        ]),
        linked_accounts=nile_ut.Table([
            Record(staff_uid=1, puid=11, is_primary_link=True,  date=b'2020-01-25'),
            Record(staff_uid=1, puid=12, is_primary_link=False, date=b'2020-01-25'),
        ]),
    )
    assert result == [Record(puid=11, component=b'component', ticket=b'ticket', story_points=1, date=b'2020-01-25')]
