from maps.wikimap.stat.libs.tracker.lib.task_id import _get_task_id
from maps.wikimap.stat.libs.tracker import get_tracker_task_id, get_dispatching_task_id

import pytest


def test_should_get_task_id():
    assert _get_task_id('queue-1', 'component 1', 'tracker') == 'tracker/queue/component 1'
    assert _get_task_id('long-queue_name-22', 'component 2', 'tracker') == 'tracker/long-queue_name/component 2'
    assert _get_task_id('queue-333', 'component 3/with/slash', 'tracker') == 'tracker/queue/component 3/with/slash'


def test_should_not_get_task_id_for_wrong_ticket_name():
    with pytest.raises(AttributeError):
        _get_task_id('queue-without-ticket-number', 'component', 'tracker')


def test_should_get_tracker_task_id():
    assert get_tracker_task_id('queue-1', 'component 1') == 'tracker/queue/component 1'


def test_should_get_dispatching_task_id():
    assert get_dispatching_task_id('queue-1', 'component 1') == 'dispatching/queue/component 1'
