CREATE SCHEMA IF NOT EXISTS mapspro;
CREATE SCHEMA IF NOT EXISTS mapspro_views;

CREATE TABLE IF NOT EXISTS mapspro.release_metrics (
    task_id bigint PRIMARY KEY,
    started_at timestamp with time zone NOT NULL,
    start_date date NOT NULL,
    branch_id bigint NOT NULL,
    task_name text NOT NULL,
    last_task_duration text NOT NULL
);

CREATE UNIQUE INDEX IF NOT EXISTS release_metrics_task_name_start_date_idx
    ON mapspro.release_metrics
    USING btree(task_name, start_date);


CREATE OR REPLACE VIEW mapspro_views.release_metrics_view AS (
    SELECT release_metrics.task_id,
        started_at::timestamp without time zone AS started_at,
        branch_id,
        task_name,
        last_task_duration
    FROM mapspro.release_metrics
);
