CREATE TYPE mapspro.days_type AS ENUM (
    'alldays',
    'workdays'
);

CREATE TYPE mapspro.user_type_type AS ENUM (
    'trusted_users',
    'common_users',
    'non_yandex_users',
    'yandex_users'
);

CREATE TYPE mapspro.in_trunk_type AS ENUM (
    'False',
    'True'
);

CREATE TABLE mapspro.deployment_sla (
    fielddate date NOT NULL,
    days int NOT NULL,
    region text NOT NULL,
    user_type int NOT NULL,
    percentile int NOT NULL,
    "window" int NOT NULL,
    budget int NOT NULL,
    in_trunk int NOT NULL,

    days__str mapspro.days_type NOT NULL,
    user_type__str mapspro.user_type_type NOT NULL,
    in_trunk__str mapspro.in_trunk_type NOT NULL,

    broken_sla int,
    real_sla int,

    bicycle_graph_broken_sla int,
    bicycle_graph_real_sla int,

    cameras_broken_sla int,
    cameras_real_sla int,

    carparks_broken_sla int,
    carparks_real_sla int,

    geocoder_broken_sla int,
    geocoder_real_sla int,

    graph_broken_sla int,
    graph_real_sla int,

    mtr_export_broken_sla int,
    mtr_export_real_sla int,

    pedestrian_graph_broken_sla int,
    pedestrian_graph_real_sla int,

    renderer_broken_sla int,
    renderer_real_sla int,

    CONSTRAINT deployment_sla_pkey PRIMARY KEY (
        fielddate,
        region,
        percentile,
        days,
        user_type,
        in_trunk,
        "window",
        budget
    )
);


CREATE TABLE mapspro.consolidated_deployment_time (
    fielddate date NOT NULL,
    days int NOT NULL,
    region text NOT NULL,
    user_type int NOT NULL,
    percentile int NOT NULL,
    in_trunk int NOT NULL,

    days__str mapspro.days_type NOT NULL,
    user_type__str mapspro.user_type_type NOT NULL,
    in_trunk__str mapspro.in_trunk_type NOT NULL,

    total int,
    total_estimated int,

    CONSTRAINT consolidated_deployment_time_pkey PRIMARY KEY (
        fielddate,
        region,
        percentile,
        days,
        user_type,
        in_trunk
    )
);


CREATE TABLE mapspro.user_edits_processing_times (
    fielddate timestamp without time zone NOT NULL,
    days int NOT NULL,
    region text NOT NULL,
    user_type int NOT NULL,
    percentile int NOT NULL,
    in_trunk int NOT NULL,

    days__str mapspro.days_type NOT NULL,
    user_type__str mapspro.user_type_type NOT NULL,
    in_trunk__str mapspro.in_trunk_type NOT NULL,

    cameras int,
    carparks int,
    geocoder int,
    graph int,
    mtr_export int,
    renderer int,
    renderer_datatesting int,
    bicycle_graph int,
    pedestrian_graph int,
    approved int,
    exported int,
    in_stable int,
    resolved int,

    CONSTRAINT user_edits_processing_times_pkey PRIMARY KEY (
        fielddate,
        region,
        percentile,
        days,
        user_type,
        in_trunk
    )
);


CREATE OR REPLACE VIEW mapspro_views.deployment_sla_view AS (
    SELECT
        (extract (epoch from fielddate) * 1000)::bigint AS fielddate__ms,
        *
    FROM mapspro.deployment_sla
);

CREATE OR REPLACE VIEW mapspro_views.consolidated_deployment_time_view AS (
    SELECT
        (extract (epoch from fielddate) * 1000)::bigint AS fielddate__ms,
        *
    FROM mapspro.consolidated_deployment_time
);

CREATE OR REPLACE VIEW mapspro_views.user_edits_processing_times_view AS (
    SELECT
        (extract (epoch from fielddate) * 1000)::bigint AS fielddate__ms,
        *
    FROM mapspro.user_edits_processing_times
);
