import common
from nile.api.v1 import (
    local,
    Record
)


def test_add_path(statface_client, job):
    job = common.make_count_job(statface_client, job)

    acl_roles_raw = [
        Record(puid='1', role=b'moderator.addr_group'),
        Record(puid='2', role=b'moderator'),
        Record(puid='3', role=b'expert.bld_group')
    ]
    nmaps_user_raw = [
        Record(puid='1', fielddate='2021-01-26', um_login='test1'),
        Record(puid='2', fielddate='2021-01-26', um_login='test2'),
        Record(puid='3', fielddate='2021-01-26', um_login='test3'),
        Record(puid='4', fielddate='2021-01-26', um_login='test4'),
    ]

    nmaps_acl_roles_add_path = []
    user_raw_join_acl_roles = []

    job.local_run(
        sources={
            'acl_roles_raw': local.StreamSource(acl_roles_raw),
            'nmaps_user_raw': local.StreamSource(nmaps_user_raw)
        },
        sinks={
            'nmaps_acl_roles_add_path': local.ListSink(nmaps_acl_roles_add_path),
            'user_raw_join_acl_roles': local.ListSink(user_raw_join_acl_roles)
        }
    )

    assert sorted(user_raw_join_acl_roles) == sorted([
        Record(puid='1', fielddate='2021-01-26', um_login='test1', role=b'moderator.addr_group'),
        Record(puid='2', fielddate='2021-01-26', um_login='test2', role=b'moderator'),
        Record(puid='3', fielddate='2021-01-26', um_login='test3', role=b'expert.bld_group')
    ])

    assert sorted(nmaps_acl_roles_add_path) == sorted([
        Record(puid='1', fielddate='2021-01-26', role_path='\t_total_\t'),
        Record(puid='1', fielddate='2021-01-26', role_path='\t_total_\tmoderator\t'),
        Record(puid='1', fielddate='2021-01-26', role_path='\t_total_\tmoderator\tlayer\t'),
        Record(puid='1', fielddate='2021-01-26', role_path='\t_total_\tmoderator\tlayer\taddr_group\t'),
        Record(puid='1', fielddate='2021-01-26', role_path='\t_total_\tmoderator\tlayer\taddr_group\ttest1 (1)\t'),
        Record(puid='2', fielddate='2021-01-26', role_path='\t_total_\t'),
        Record(puid='2', fielddate='2021-01-26', role_path='\t_total_\tmoderator\t'),
        Record(puid='2', fielddate='2021-01-26', role_path='\t_total_\tmoderator\tall\t'),
        Record(puid='2', fielddate='2021-01-26', role_path='\t_total_\tmoderator\tall\ttest2 (2)\t'),
        Record(puid='3', fielddate='2021-01-26', role_path='\t_total_\t'),
        Record(puid='3', fielddate='2021-01-26', role_path='\t_total_\texpert\t'),
        Record(puid='3', fielddate='2021-01-26', role_path='\t_total_\texpert\tlayer\t'),
        Record(puid='3', fielddate='2021-01-26', role_path='\t_total_\texpert\tlayer\tbld_group\t'),
        Record(puid='3', fielddate='2021-01-26', role_path='\t_total_\texpert\tlayer\tbld_group\ttest3 (3)\t')
    ])


def test_prepare_result_counts(statface_client, job):
    job = common.make_count_job(statface_client, job)

    nmaps_acl_roles_add_path = [
        Record(puid='1', fielddate='2021-01-26', role_path='\t_total_\t'),
        Record(puid='1', fielddate='2021-01-26', role_path='\t_total_\tmoderator\t'),
        Record(puid='1', fielddate='2021-01-26', role_path='\t_total_\tmoderator\tlayer\t'),
        Record(puid='1', fielddate='2021-01-26', role_path='\t_total_\tmoderator\tlayer\taddr_group\t'),
        Record(puid='1', fielddate='2021-01-26', role_path='\t_total_\tmoderator\tlayer\taddr_group\ttest1 (1)\t'),
        Record(puid='2', fielddate='2021-01-26', role_path='\t_total_\t'),
        Record(puid='2', fielddate='2021-01-26', role_path='\t_total_\tmoderator\t'),
        Record(puid='2', fielddate='2021-01-26', role_path='\t_total_\tmoderator\tall\t'),
        Record(puid='2', fielddate='2021-01-26', role_path='\t_total_\tmoderator\tall\ttest2 (2)\t'),
        Record(puid='3', fielddate='2021-01-26', role_path='\t_total_\t'),
        Record(puid='3', fielddate='2021-01-26', role_path='\t_total_\texpert\t'),
        Record(puid='3', fielddate='2021-01-26', role_path='\t_total_\texpert\tlayer\t'),
        Record(puid='3', fielddate='2021-01-26', role_path='\t_total_\texpert\tlayer\tbld_group\t'),
        Record(puid='3', fielddate='2021-01-26', role_path='\t_total_\texpert\tlayer\tbld_group\ttest3 (3)\t')
    ]

    prepare_result_counts = []

    job.local_run(
        sources={
            'nmaps_acl_roles_add_path': local.StreamSource(nmaps_acl_roles_add_path)
        },
        sinks={
            'prepare_result_counts': local.ListSink(prepare_result_counts)
        }
    )

    assert sorted(prepare_result_counts) == sorted([
        Record(count_uniq_puid=2, fielddate='2021-01-26', role_path='\t_total_\tmoderator\t'),
        Record(count_uniq_puid=1, fielddate='2021-01-26', role_path='\t_total_\tmoderator\tlayer\t'),
        Record(count_uniq_puid=1, fielddate='2021-01-26', role_path='\t_total_\tmoderator\tlayer\taddr_group\t'),
        Record(count_uniq_puid=1, fielddate='2021-01-26', role_path='\t_total_\tmoderator\tlayer\taddr_group\ttest1 (1)\t'),
        Record(count_uniq_puid=1, fielddate='2021-01-26', role_path='\t_total_\tmoderator\tall\t'),
        Record(count_uniq_puid=1, fielddate='2021-01-26', role_path='\t_total_\tmoderator\tall\ttest2 (2)\t'),
        Record(count_uniq_puid=3, fielddate='2021-01-26', role_path='\t_total_\t'),
        Record(count_uniq_puid=1, fielddate='2021-01-26', role_path='\t_total_\texpert\t'),
        Record(count_uniq_puid=1, fielddate='2021-01-26', role_path='\t_total_\texpert\tlayer\t'),
        Record(count_uniq_puid=1, fielddate='2021-01-26', role_path='\t_total_\texpert\tlayer\tbld_group\t'),
        Record(count_uniq_puid=1, fielddate='2021-01-26', role_path='\t_total_\texpert\tlayer\tbld_group\ttest3 (3)\t')
    ])
