import maps.wikimap.stat.nmaps_count_moderation_event_type.lib.job_options as jo
import maps.wikimap.stat.nmaps_count_moderation_event_type.lib.eval_report as eval_report
import maps.wikimap.stat.libs.common.lib.cli_options as cli_opts
from maps.pylibs.utils.lib.common import require

from nile.api.v1 import cli


COUNT_REPORT_PATH = 'Maps.Wiki/Others/NmapsAnalytics/NmapsModEventType'
COUNT_TEST_REPORT_PATH = 'Maps.Wiki/Others/fricks/NmapsModEventType_test'


@cli.statinfra_job(options=jo.JOB_OPTIONS)
def make_job(job, options, statface_client):
    require(
        options.scale == 'daily',
        RuntimeError("Use 'daily' in --scale parameter")
    )

    fielddate = jo.extract_fielddate(options)
    return eval_report.make_job(
        job,
        options.scale,
        statface_client,
        fielddate,
        COUNT_REPORT_PATH,
        cli_opts.get_results_path(options),
    )


def main():
    cli.run()
