from . import stream_processors
from nile.api.v1 import (
    statface as ns
)


MAJOR_REGIONS_TABLE = '//home/maps/core/nmaps/analytics/geo-data/major_regions_map'


def make_user_edit_data(job, date, major_regions):
    '''
    Main work of statistics
    1. Prepare raw tables: nmaps_edits_raw, nmaps_moderation_raw, nmaps_user_raw, nmaps_acl_role_raw
    2. Add tree for action, object_type, moderation_status and region_id
    3. Aggregate tables and count result for Statface
    '''
    nmaps_edits_raw = stream_processors.make_nmaps_edit_raws(job, date)
    nmaps_moderation_raw = stream_processors.make_nmaps_moderation_raws(job, date)
    nmaps_user_raw = stream_processors.make_nmaps_user_raw(job, date)
    nmaps_acl_role_raw = stream_processors.make_nmaps_acl_roles_raw(job, date)

    nmaps_moderation_geo_with_path = stream_processors.add_paths(
        job,
        nmaps_edits_raw,
        nmaps_moderation_raw,
        nmaps_user_raw,
        nmaps_acl_role_raw
    )

    nmaps_moderation_geo_all_path = stream_processors.set_region_tree(nmaps_moderation_geo_with_path, major_regions)

    return stream_processors.prepare_result_counts(
        nmaps_moderation_geo_all_path
    ).label('prepare_result_counts')


def publish_data(report_data, report_name, scale, statface_client, job, date):
    '''
    Publish results in Statface
    '''
    report = ns.StatfaceReport() \
        .path(report_name) \
        .scale(scale) \
        .client(statface_client) \
        .default_max_distance(1)

    report_data.publish(
        report,
        allow_change_job=True
    )

    return job


def make_job(job, scale, statface_client, date, report_name, result_path=None):
    major_regions = job.table(
        MAJOR_REGIONS_TABLE
    ).label('major_regions')

    report_data = make_user_edit_data(job, date, major_regions)

    job = publish_data(
        report_data,
        report_name,
        scale,
        statface_client,
        job,
        date
    )
    return job
