import common
from nile.api.v1 import (
    local,
    Record
)
import maps.wikimap.stat.nmaps_count_moderation_geo.lib.edits_constants as edits_constants


def test_create_category_groups_dict():
    define_category_groups_dict = {
        'rd': 'rd_group',
        'rd_el': 'rd_group',
        'rd_jc': 'rd_group',
        'cond': 'cond_group',
        'cond_annotation': 'cond_group',
        'cond_cam': 'cond_group',
        'ad': 'ad_group',
        'ad_subst': 'ad_group',
        'ad_cnt': 'ad_group',
        'ad_jc': 'ad_group',
        'bld': 'bld_group',
        'bld_complex': 'bld_group',
    }

    test_xml_string = '''<?xml version="1.0" encoding="UTF-8"?>
<category-groups xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="categories.xsd">
<category-group id="rd_group" ugc_valuable="true">
    <label>{{category-groups:rd_group}}</label>
    <categories>
    <category id="rd"/>
    <category id="rd_el"/>
    <category id="rd_jc"/>
    </categories>
</category-group>
<category-group id="cond_group" ugc_valuable="true">
    <label>{{category-groups:cond_group}}</label>
    <categories>
    <category id="cond"/>
    <category id="cond_annotation"/>
    <category id="cond_cam"/>
    </categories>
</category-group>
<category-group id="ad_group" ugc_valuable="true">
    <label>{{category-groups:ad_group}}</label>
    <categories>
    <category id="ad"/>
    <category id="ad_subst"/>
    <category id="ad_cnt"/>
    <category id="ad_jc"/>
    </categories>
</category-group>
<category-group id="bld_group" ugc_valuable="true">
    <label>{{category-groups:bld_group}}</label>
    <categories>
    <category id="bld"/>
    <category id="bld_complex"/>
    </categories>
</category-group>
</category-groups>'''

    assert define_category_groups_dict == edits_constants.create_category_groups_dict(
        test_xml_string)


def test_add_path_add_user_status(statface_client, job, major_regions, geobase_fixture):
    job = common.make_count_job(statface_client, job)

    nmaps_edit_raw = [
        Record(puid=1, action='object-modified', edit_raw_commit_id=1, edit_raw_object_id=1),
        Record(puid=2, action='object-modified', edit_raw_commit_id=2, edit_raw_object_id=3),
    ]

    nmaps_moderation_raw = [
        Record(puid=1, action='object-modified', commit_id=1, task_id=1, object_id=1, object_category='rd_el',
               resolution='edit', fielddate='2021-01-12', unixtime=1234567.0, region_id='213'),
        Record(puid=2, action='object-modified', commit_id=2, task_id=2, object_id=2, object_category='ad',
               resolution='approve', fielddate='2021-01-12', unixtime=1235467.0, region_id='213')
    ]
    nmaps_user_raw = [
        Record(puid=1, um_login='test_1', moderation_status='yandex-moderator'),
        Record(puid=2, um_login='test_2', moderation_status='cartographer')
    ]

    nmaps_acl_roles_raw = [
        Record(puid=1, acl_role='expert.rd_group'),
        Record(puid=2, acl_role='moderator.ad_group')
    ]

    join_all_table = []
    create_object_path = []
    create_user_path = []
    create_action_path = []
    moderation_geo_with_paths = []
    add_geo_path = []

    job.local_run(
        sources={
            'major_regions': local.StreamSource(major_regions),
            'nmaps_edit_raw': local.StreamSource(nmaps_edit_raw),
            'nmaps_moderation_raw': local.StreamSource(nmaps_moderation_raw),
            'nmaps_user_raw': local.StreamSource(nmaps_user_raw),
            'nmaps_acl_roles_raw': local.StreamSource(nmaps_acl_roles_raw)
        },
        sinks={
            'join_all_table': local.ListSink(join_all_table),
            'create_object_path': local.ListSink(create_object_path),
            'create_user_path': local.ListSink(create_user_path),
            'create_action_path': local.ListSink(create_action_path),
            'moderation_geo_with_paths': local.ListSink(moderation_geo_with_paths),
            'add_geo_path': local.ListSink(add_geo_path)
        }
    )

    assert sorted(join_all_table) == sorted([
        Record(acl_role='expert.rd_group', action='object-modified', commit_id=1, edit_commit_id=1, edit_object_id=1,
               edit_raw_commit_id=1, edit_raw_object_id=1, fielddate='2021-01-12', moderation_status='yandex-moderator',
               object_category='rd_el', object_id=1, puid=1, region_id='213', resolution='edit', role='expert.rd_group',
               task_id=1, um_login='test_1', unixtime=1234567.0),
        Record(acl_role='moderator.ad_group', action='object-modified', commit_id=2, edit_commit_id=2, edit_object_id=3,
               edit_raw_commit_id=2, edit_raw_object_id=3, fielddate='2021-01-12', moderation_status='cartographer',
               object_category='ad', object_id=2, puid=2, region_id='213', resolution='approve', role='moderator.ad_group',
               task_id=2, um_login='test_2', unixtime=1235467.0)
    ])

    assert sorted(create_object_path) == sorted([
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1, fielddate='2021-01-12',
               moderation_status='yandex-moderator', object_id=1, object_path='\t_total_\t', puid=1, resolution='edit',
               role='expert.rd_group', um_login='test_1', unixtime=1234567.0, region_id='213'),
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1, fielddate='2021-01-12',
               moderation_status='yandex-moderator', object_id=1, object_path='\t_total_\trd_group\t', puid=1,
               resolution='edit', role='expert.rd_group', um_login='test_1', unixtime=1234567.0, region_id='213'),
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1, fielddate='2021-01-12',
               moderation_status='yandex-moderator', object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1,
               resolution='edit', role='expert.rd_group', um_login='test_1', unixtime=1234567.0, region_id='213'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3, fielddate='2021-01-12',
               moderation_status='cartographer', object_id=2, object_path='\t_total_\t', puid=2, resolution='approve',
               role='moderator.ad_group', um_login='test_2', unixtime=1235467.0, region_id='213'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3, fielddate='2021-01-12',
               moderation_status='cartographer', object_id=2, object_path='\t_total_\tad_group\t', puid=2,
               resolution='approve', role='moderator.ad_group', um_login='test_2', unixtime=1235467.0, region_id='213'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3, fielddate='2021-01-12',
               moderation_status='cartographer', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2,
               resolution='approve', role='moderator.ad_group', um_login='test_2', unixtime=1235467.0, region_id='213')
    ])

    assert sorted(create_user_path) == sorted([
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1, object_path='\t_total_\t',
               puid=1, resolution='edit', role='expert.rd_group', unixtime=1234567.0, user_path='\t_total_\t',
               region_id='213'),
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1, object_path='\t_total_\t',
               puid=1, resolution='edit', role='expert.rd_group', unixtime=1234567.0, user_path='\t_total_\tyandex\t',
               region_id='213'),
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1, object_path='\t_total_\t',
               puid=1, resolution='edit', role='expert.rd_group', unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t', region_id='213'),
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1, object_path='\t_total_\t',
               puid=1, resolution='edit', role='expert.rd_group', unixtime=1234567.0, region_id='213',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\t', region_id='213'),
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\tyandex\t', region_id='213'),
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, region_id='213', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, region_id='213', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\t', region_id='213'),
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\tyandex\t', region_id='213'),
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, region_id='213', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action='object-modified', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, region_id='213', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2, object_path='\t_total_\t', puid=2,
               resolution='approve', role='moderator.ad_group', unixtime=1235467.0, user_path='\t_total_\t',
               region_id='213'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2, object_path='\t_total_\t', puid=2,
               resolution='approve', role='moderator.ad_group', unixtime=1235467.0, user_path='\t_total_\tyandex\t',
               region_id='213'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2, object_path='\t_total_\t', puid=2,
               resolution='approve', role='moderator.ad_group', unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\t', region_id='213'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2, object_path='\t_total_\t', puid=2,
               resolution='approve', role='moderator.ad_group', unixtime=1235467.0, region_id='213',
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\t', region_id='213'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\tyandex\t', region_id='213'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, region_id='213', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, region_id='213', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\t', region_id='213'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\tyandex\t', region_id='213'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, region_id='213', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action='object-modified', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, region_id='213', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t')
    ])

    assert sorted(create_action_path) == sorted([
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1, object_path='\t_total_\t',
               puid=1, resolution='edit', role='expert.rd_group', unixtime=1234567.0, user_path='\t_total_\t',
               region_id='213'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1, object_path='\t_total_\t',
               puid=1, resolution='edit', role='expert.rd_group', unixtime=1234567.0, user_path='\t_total_\tyandex\t',
               region_id='213'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1, object_path='\t_total_\t',
               puid=1, resolution='edit', role='expert.rd_group', unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1, object_path='\t_total_\t',
               puid=1, resolution='edit', role='expert.rd_group', unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\tyandex\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\tyandex\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2, object_path='\t_total_\t', puid=2,
               resolution='approve', role='moderator.ad_group', unixtime=1235467.0, user_path='\t_total_\t',
               region_id='213'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2, object_path='\t_total_\t', puid=2,
               resolution='approve', role='moderator.ad_group', unixtime=1235467.0, user_path='\t_total_\tyandex\t',
               region_id='213'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2, object_path='\t_total_\t', puid=2,
               resolution='approve', role='moderator.ad_group', unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2, object_path='\t_total_\t', puid=2,
               resolution='approve', role='moderator.ad_group', unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\tyandex\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\tyandex\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t', region_id='213'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\t', puid=1, resolution='edit', role='expert.rd_group', unixtime=1234567.0,
               user_path='\t_total_\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\t', puid=1, resolution='edit', role='expert.rd_group', unixtime=1234567.0,
               user_path='\t_total_\tyandex\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\t', puid=1, resolution='edit', role='expert.rd_group', unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\t', puid=1, resolution='edit', role='expert.rd_group', unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\tyandex\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\tyandex\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, fielddate='2021-01-12', moderation_status='yandex-moderator', object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution='edit', role='expert.rd_group',
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\t', puid=2, resolution='approve', role='moderator.ad_group', unixtime=1235467.0,
               user_path='\t_total_\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\t', puid=2, resolution='approve', role='moderator.ad_group', unixtime=1235467.0,
               user_path='\t_total_\tyandex\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\t', puid=2, resolution='approve', role='moderator.ad_group', unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\t', puid=2, resolution='approve', role='moderator.ad_group', unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\tyandex\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\tyandex\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t', region_id='213'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, fielddate='2021-01-12', moderation_status='cartographer', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution='approve', role='moderator.ad_group',
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t', region_id='213')
    ])

    assert sorted(moderation_geo_with_paths) == sorted([
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\t', puid=1, region_id='213', resolution='edit', role='expert.rd_group', task_id=1,
               unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\t', puid=1, region_id='213', resolution='edit', role='expert.rd_group', task_id=1,
               unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\t', puid=1, region_id='213', resolution='edit', role='expert.rd_group', task_id=1,
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\t', puid=1, region_id='213', resolution='edit', role='expert.rd_group', task_id=1,
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\t', puid=2, region_id='213', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\t', puid=2, region_id='213', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\t', puid=2, region_id='213', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\t', puid=2, region_id='213', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None,
               object_id=1, object_path='\t_total_\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None,
               object_id=1, object_path='\t_total_\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None,
               object_id=1, object_path='\t_total_\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None,
               object_id=1, object_path='\t_total_\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None,
               object_id=1, object_path='\t_total_\trd_group\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None,
               object_id=1, object_path='\t_total_\trd_group\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None,
               object_id=1, object_path='\t_total_\trd_group\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None,
               object_id=1, object_path='\t_total_\trd_group\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None,
               object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None,
               object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None,
               object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', moderation_status='yandex-moderator', moderator_role=None,
               object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да',
               object_id=2, object_path='\t_total_\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да',
               object_id=2, object_path='\t_total_\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да',
               object_id=2, object_path='\t_total_\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да',
               object_id=2, object_path='\t_total_\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да',
               object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да',
               object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да',
               object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да',
               object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да',
               object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да',
               object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да',
               object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', moderation_status='cartographer', moderator_role='Да',
               object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t')
    ])

    assert sorted(add_geo_path) == sorted([
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\t', puid=1, region_id='213',
               region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\t', puid=1, region_id='213',
               region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\t', puid=1, region_id='213',
               region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\t', puid=1, region_id='213',
               region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\t', puid=1, region_id='213',
               region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\t', puid=1, region_id='213',
               region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\t', puid=1, region_id='213',
               region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\t', puid=1, region_id='213',
               region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213',
               region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213',
               region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213',
               region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213',
               region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\t', puid=1, region_id='213',
               region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\t', puid=1, region_id='213',
               region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\t', puid=1, region_id='213',
               region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\t', puid=1, region_id='213',
               region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\t', puid=1, region_id='213',
               region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\t', puid=1, region_id='213',
               region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\t', puid=1, region_id='213',
               region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\t', puid=1, region_id='213',
               region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213',
               region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213',
               region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213',
               region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213',
               region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t225\t213\t', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t225\t213\t', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t225\t213\t', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t225\t213\t', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, edit_commit_id=1, edit_object_id=1, expert_role='Да',
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, region_id='213',
               region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, region_id='213',
               region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, region_id='213',
               region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, region_id='213',
               region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213',
               region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213',
               region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213',
               region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213',
               region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213',
               region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213',
               region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213',
               region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213',
               region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, edit_commit_id=2, edit_object_id=3, expert_role=None,
               fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213', moderation_status='cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213',
               region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1,
               unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1,
               unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1,
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t', resolution='edit', role='expert.rd_group', task_id=1,
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t', resolution='edit',
               role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t225\t', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t225\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t225\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t225\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t225\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t225\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t225\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t225\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t225\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t225\t213\t', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t225\t213\t', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t225\t213\t', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, region_id='213', region_tree='\t10000\t225\t213\t', resolution='edit', role='expert.rd_group',
               task_id=1, unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='edit', role='expert.rd_group', task_id=1, unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               region_id='213', region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               region_id='213', region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               region_id='213', region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               region_id='213', region_tree='\t10000\t', resolution='approve', role='moderator.ad_group', task_id=2,
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, region_id='213', region_tree='\t10000\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, region_id='213', region_tree='\t10000\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, region_id='213', region_tree='\t10000\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, region_id='213', region_tree='\t10000\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', region_tree='\t10000\t',
               resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', region_tree='\t10000\t',
               resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', region_tree='\t10000\t',
               resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', major_id='10000',
               moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', region_tree='\t10000\t',
               resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               region_id='213', region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               region_id='213', region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               region_id='213', region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               region_id='213', region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, region_id='213', region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, region_id='213', region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, region_id='213', region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, region_id='213', region_tree='\t10000\t225\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', region_tree='\t10000\t225\t',
               resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', region_tree='\t10000\t225\t',
               resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', region_tree='\t10000\t225\t',
               resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t', major_id='225',
               moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', region_tree='\t10000\t225\t',
               resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               region_id='213', region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               region_id='213', region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               region_id='213', region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               region_id='213', region_tree='\t10000\t225\t213\t', resolution='approve', role='moderator.ad_group',
               task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, region_id='213', region_tree='\t10000\t225\t213\t', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, region_id='213', region_tree='\t10000\t225\t213\t', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, region_id='213', region_tree='\t10000\t225\t213\t', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, region_id='213', region_tree='\t10000\t225\t213\t', resolution='approve',
               role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t225\t213\t', major_id='213',
               moderation_status='cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', region_tree='\t10000\t225\t213\t',
               resolution='approve', role='moderator.ad_group', task_id=2, unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t')
    ])


def test_prepare_result_counts(statface_client, job):
    job = common.make_count_job(statface_client, job)

    add_geo_path = [
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\t', puid=1, resolution=b'edit',
               unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\t', puid=1, resolution=b'edit',
               unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\t', puid=1, resolution=b'edit',
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\t', puid=1, resolution=b'edit',
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\t', puid=1, resolution=b'edit',
               unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\t', puid=1, resolution=b'edit',
               unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\t', puid=1, resolution=b'edit',
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\t', puid=1, resolution=b'edit',
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution=b'edit',
               unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution=b'edit',
               unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution=b'edit',
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', commit_id=1, task_id=1, edit_commit_id=1, edit_object_id=1,
               expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'yandex-moderator',
               moderator_role=None, object_id=1, object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution=b'edit',
               unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, resolution=b'approve',
               unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, resolution=b'approve',
               unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, resolution=b'approve',
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2, resolution=b'approve',
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, resolution=b'approve',
               unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, resolution=b'approve',
               unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, resolution=b'approve',
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t', puid=2, resolution=b'approve',
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, resolution=b'approve',
               unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, resolution=b'approve',
               unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, resolution=b'approve',
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', commit_id=2, task_id=2, edit_commit_id=2, edit_object_id=3,
               expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t', moderation_status=b'cartographer',
               moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\tad\t', puid=2, resolution=b'approve',
               unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, resolution=b'edit', unixtime=1234567.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, resolution=b'edit', unixtime=1234567.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, resolution=b'edit', unixtime=1234567.0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'yandex-moderator', moderator_role=None, object_id=1, object_path='\t_total_\t',
               puid=1, resolution=b'edit', unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution=b'edit', unixtime=1234567.0,
               user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution=b'edit', unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution=b'edit', unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\t', puid=1, resolution=b'edit', unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution=b'edit', unixtime=1234567.0,
               user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution=b'edit', unixtime=1234567.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution=b'edit', unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=1, task_id=1, edit_commit_id=1,
               edit_object_id=1, expert_role='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'yandex-moderator', moderator_role=None, object_id=1,
               object_path='\t_total_\trd_group\trd_el\t', puid=1, resolution=b'edit', unixtime=1234567.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               resolution=b'approve', unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               resolution=b'approve', unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               resolution=b'approve', unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\t', puid=2,
               resolution=b'approve', unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, resolution=b'approve', unixtime=1235467.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, resolution=b'approve', unixtime=1235467.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, resolution=b'approve', unixtime=1235467.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'cartographer', moderator_role='Да', object_id=2, object_path='\t_total_\tad_group\t',
               puid=2, resolution=b'approve', unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution=b'approve', unixtime=1235467.0,
               user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution=b'approve', unixtime=1235467.0,
               user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution=b'approve', unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', commit_id=2, task_id=2, edit_commit_id=2,
               edit_object_id=3, expert_role=None, fielddate='2021-01-12', geo_path='\t10000\t',
               moderation_status=b'cartographer', moderator_role='Да', object_id=2,
               object_path='\t_total_\tad_group\tad\t', puid=2, resolution=b'approve', unixtime=1235467.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t')
    ]

    aggregate_by_edited_objects = []
    aggregate_by_edits = []
    aggregate_by_commit_id = []
    aggregate_by_object_id = []
    aggregate_by_expert = []
    aggregate_by_moderator = []
    aggregate_by_session = []
    aggregate_by_link = []
    aggregate_by_right_cart_res = []
    aggregate_by_total_cart_res = []
    prepare_result_counts = []

    job.local_run(
        sources={
            'add_geo_path': local.StreamSource(add_geo_path)
        },
        sinks={
            'aggregate_by_edited_objects': local.ListSink(aggregate_by_edited_objects),
            'aggregate_by_edits': local.ListSink(aggregate_by_edits),
            'aggregate_by_commit_id': local.ListSink(aggregate_by_commit_id),
            'aggregate_by_object_id': local.ListSink(aggregate_by_object_id),
            'aggregate_by_expert': local.ListSink(aggregate_by_expert),
            'aggregate_by_moderator': local.ListSink(aggregate_by_moderator),
            'aggregate_by_session': local.ListSink(aggregate_by_session),
            'aggregate_by_link': local.ListSink(aggregate_by_link),
            'aggregate_by_right_cart_res': local.ListSink(aggregate_by_right_cart_res),
            'aggregate_by_total_cart_res': local.ListSink(aggregate_by_total_cart_res),
            'prepare_result_counts': local.ListSink(prepare_result_counts)
        }
    )

    assert sorted(aggregate_by_edited_objects) == sorted([
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', edited_objects=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', edited_objects=2, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', edited_objects=2, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\t',
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\t',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\tad_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\tad_group\t',
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\tad_group\t',
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\tad_group\tad\t',
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\tad_group\tad\t',
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\trd_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\trd_group\t',
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\trd_group\t',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\trd_group\trd_el\t',
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=1, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\trd_group\trd_el\t',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=2, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', edited_objects=2, fielddate='2021-01-12',
               geo_path='\t10000\t', object_path='\t_total_\t', user_path='\t_total_\tyandex\t')
    ])

    assert sorted(aggregate_by_edits) == sorted([
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', edits=2, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', edits=2, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=2, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', edits=2, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\t')
    ])

    assert sorted(aggregate_by_commit_id) == sorted([
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', as_mod=2, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod=2, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=2, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=2, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\t')
    ])

    assert sorted(aggregate_by_object_id) == sorted([
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', as_mod_obj=2, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod_obj=2, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=1, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=2, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod_obj=2, fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\t')
    ])

    assert sorted(aggregate_by_expert) == sorted([
        Record(action_path='\t_total_\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t')
    ])

    assert sorted(aggregate_by_moderator) == sorted([
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', moderator='Да',
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t')
    ])

    assert sorted(aggregate_by_session) == sorted([
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', object_path='\t_total_\t',
               session=0.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', object_path='\t_total_\t',
               session=0.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', object_path='\t_total_\t',
               session=0.0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', object_path='\t_total_\t',
               session=0.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', object_path='\t_total_\t',
               session=0.25, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', object_path='\t_total_\t',
               session=0.25, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', session=0.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', session=0.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', session=0.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', session=0.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', session=0.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', session=0.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', session=0.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', session=0.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', session=0.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', session=0.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', session=0.0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', session=0.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', session=0.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', session=0.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', session=0.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', session=0.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', session=0.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', session=0.0, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', session=0.0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', session=0.0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', session=0.25, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', session=0.25, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', session=0.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', session=0.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', session=0.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', session=0.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', session=0.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', session=0.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', session=0.0, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', session=0.0,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', session=0.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', session=0.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', session=0.0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\t', session=0.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', session=0.0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', session=0.0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', session=0.0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\trd_group\trd_el\t', session=0.0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t')
    ])

    assert sorted(aggregate_by_link) == sorted([
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\trd_el\t',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\t', user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\trd_el\t', user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=1,
               object_path='\t_total_\trd_group\trd_el\t',
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t', link=2,
               object_path='\t_total_\tad_group\tad\t', user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t')
    ])

    assert sorted(aggregate_by_right_cart_res) == sorted([
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', object_path='\t_total_\t',
               sum_right_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', object_path='\t_total_\t',
               sum_right_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', object_path='\t_total_\t',
               sum_right_cart_res=1, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', object_path='\t_total_\t',
               sum_right_cart_res=1, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_right_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_right_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_right_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_right_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_right_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_right_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_right_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_right_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', sum_right_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', sum_right_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', sum_right_cart_res=1, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', sum_right_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_right_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_right_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_right_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_right_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_right_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_right_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_right_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_right_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t')
    ])

    assert sorted(aggregate_by_total_cart_res) == sorted([
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', object_path='\t_total_\t',
               sum_total_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', object_path='\t_total_\t',
               sum_total_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', object_path='\t_total_\t',
               sum_total_cart_res=1, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t', object_path='\t_total_\t',
               sum_total_cart_res=1, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_total_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_total_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_total_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_total_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_total_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_total_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_total_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_total_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', sum_total_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', sum_total_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', sum_total_cart_res=1, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\t', sum_total_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_total_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_total_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_total_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\t', sum_total_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_total_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_total_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_total_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', fielddate='2021-01-12', geo_path='\t10000\t',
               object_path='\t_total_\tad_group\tad\t', sum_total_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t')
    ])

    assert sorted(prepare_result_counts) == sorted([
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12', geo_path='\t10000\t',
               link=2, moderator='Да', object_path='\t_total_\t', session=0, sum_right_cart_res=1, sum_total_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12', geo_path='\t10000\t',
               link=2, moderator='Да', object_path='\t_total_\t', session=0, sum_right_cart_res=1, sum_total_cart_res=1,
               user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12', geo_path='\t10000\t',
               link=2, moderator='Да', object_path='\t_total_\tad_group\t', session=0, sum_right_cart_res=1,
               sum_total_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12', geo_path='\t10000\t',
               link=2, moderator='Да', object_path='\t_total_\tad_group\t', session=0, sum_right_cart_res=1,
               sum_total_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12', geo_path='\t10000\t',
               link=2, moderator='Да', object_path='\t_total_\tad_group\t', session=0, sum_right_cart_res=1,
               sum_total_cart_res=1, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12', geo_path='\t10000\t',
               link=2, moderator='Да', object_path='\t_total_\tad_group\t', session=0, sum_right_cart_res=1,
               sum_total_cart_res=1, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12', geo_path='\t10000\t',
               link=2, moderator='Да', object_path='\t_total_\tad_group\tad\t', session=0, sum_right_cart_res=1,
               sum_total_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12', geo_path='\t10000\t',
               link=2, moderator='Да', object_path='\t_total_\tad_group\tad\t', session=0, sum_right_cart_res=1,
               sum_total_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12', geo_path='\t10000\t',
               link=2, moderator='Да', object_path='\t_total_\tad_group\tad\t', session=0, sum_right_cart_res=1,
               sum_total_cart_res=1, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12', geo_path='\t10000\t',
               link=2, moderator='Да', object_path='\t_total_\tad_group\tad\t', session=0, sum_right_cart_res=1,
               sum_total_cart_res=1, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               link=1, moderator=None, object_path='\t_total_\t', session=0, sum_right_cart_res=0, sum_total_cart_res=0,
               user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               link=1, moderator=None, object_path='\t_total_\t', session=0, sum_right_cart_res=0, sum_total_cart_res=0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               link=1, moderator=None, object_path='\t_total_\trd_group\t', session=0, sum_right_cart_res=0,
               sum_total_cart_res=0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               link=1, moderator=None, object_path='\t_total_\trd_group\t', session=0, sum_right_cart_res=0,
               sum_total_cart_res=0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               link=1, moderator=None, object_path='\t_total_\trd_group\t', session=0, sum_right_cart_res=0,
               sum_total_cart_res=0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               link=1, moderator=None, object_path='\t_total_\trd_group\t', session=0, sum_right_cart_res=0,
               sum_total_cart_res=0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               link=1, moderator=None, object_path='\t_total_\trd_group\trd_el\t', session=0, sum_right_cart_res=0,
               sum_total_cart_res=0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               link=1, moderator=None, object_path='\t_total_\trd_group\trd_el\t', session=0, sum_right_cart_res=0,
               sum_total_cart_res=0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               link=1, moderator=None, object_path='\t_total_\trd_group\trd_el\t', session=0, sum_right_cart_res=0,
               sum_total_cart_res=0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0, count_uniq_task_id=1,
               edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               link=1, moderator=None, object_path='\t_total_\trd_group\trd_el\t', session=0, sum_right_cart_res=0,
               sum_total_cart_res=0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\t', as_mod=2, as_mod_obj=2, auto_hard=0, auto_simple=0, count_uniq_task_id=2,
               edited_non_auto=0, edited_objects=2, edits=2, expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               link=2, moderator='Да', object_path='\t_total_\t', session=0.25, sum_right_cart_res=1,
               sum_total_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\t', as_mod=2, as_mod_obj=2, auto_hard=0, auto_simple=0, count_uniq_task_id=2,
               edited_non_auto=0, edited_objects=2, edits=2, expert='Да', fielddate='2021-01-12', geo_path='\t10000\t',
               link=2, moderator='Да', object_path='\t_total_\t', session=0.25, sum_right_cart_res=1,
               sum_total_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12',
               geo_path='\t10000\t', link=2, moderator='Да', object_path='\t_total_\t', session=0, sum_right_cart_res=1,
               sum_total_cart_res=1, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12',
               geo_path='\t10000\t', link=2, moderator='Да', object_path='\t_total_\t', session=0, sum_right_cart_res=1,
               sum_total_cart_res=1, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12',
               geo_path='\t10000\t', link=2, moderator='Да', object_path='\t_total_\tad_group\t', session=0,
               sum_right_cart_res=1, sum_total_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12',
               geo_path='\t10000\t', link=2, moderator='Да', object_path='\t_total_\tad_group\t', session=0,
               sum_right_cart_res=1, sum_total_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12',
               geo_path='\t10000\t', link=2, moderator='Да', object_path='\t_total_\tad_group\t', session=0,
               sum_right_cart_res=1, sum_total_cart_res=1, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12',
               geo_path='\t10000\t', link=2, moderator='Да', object_path='\t_total_\tad_group\t', session=0,
               sum_right_cart_res=1, sum_total_cart_res=1, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12',
               geo_path='\t10000\t', link=2, moderator='Да', object_path='\t_total_\tad_group\tad\t', session=0,
               sum_right_cart_res=1, sum_total_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12',
               geo_path='\t10000\t', link=2, moderator='Да', object_path='\t_total_\tad_group\tad\t', session=0,
               sum_right_cart_res=1, sum_total_cart_res=1, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12',
               geo_path='\t10000\t', link=2, moderator='Да', object_path='\t_total_\tad_group\tad\t', session=0,
               sum_right_cart_res=1, sum_total_cart_res=1, user_path='\t_total_\tyandex\tcartographer\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert=None, fielddate='2021-01-12',
               geo_path='\t10000\t', link=2, moderator='Да', object_path='\t_total_\tad_group\tad\t', session=0,
               sum_right_cart_res=1, sum_total_cart_res=1, user_path='\t_total_\tyandex\tcartographer\ttest_2 (2)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12',
               geo_path='\t10000\t', link=1, moderator=None, object_path='\t_total_\t', session=0, sum_right_cart_res=0,
               sum_total_cart_res=0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12',
               geo_path='\t10000\t', link=1, moderator=None, object_path='\t_total_\t', session=0, sum_right_cart_res=0,
               sum_total_cart_res=0, user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12',
               geo_path='\t10000\t', link=1, moderator=None, object_path='\t_total_\trd_group\t', session=0,
               sum_right_cart_res=0, sum_total_cart_res=0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12',
               geo_path='\t10000\t', link=1, moderator=None, object_path='\t_total_\trd_group\t', session=0,
               sum_right_cart_res=0, sum_total_cart_res=0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12',
               geo_path='\t10000\t', link=1, moderator=None, object_path='\t_total_\trd_group\t', session=0,
               sum_right_cart_res=0, sum_total_cart_res=0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12',
               geo_path='\t10000\t', link=1, moderator=None, object_path='\t_total_\trd_group\t', session=0,
               sum_right_cart_res=0, sum_total_cart_res=0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12',
               geo_path='\t10000\t', link=1, moderator=None, object_path='\t_total_\trd_group\trd_el\t', session=0,
               sum_right_cart_res=0, sum_total_cart_res=0, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12',
               geo_path='\t10000\t', link=1, moderator=None, object_path='\t_total_\trd_group\trd_el\t', session=0,
               sum_right_cart_res=0, sum_total_cart_res=0, user_path='\t_total_\tyandex\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12',
               geo_path='\t10000\t', link=1, moderator=None, object_path='\t_total_\trd_group\trd_el\t', session=0,
               sum_right_cart_res=0, sum_total_cart_res=0, user_path='\t_total_\tyandex\tyandex-moderator\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=1, as_mod_obj=1, auto_hard=0, auto_simple=0,
               count_uniq_task_id=1, edited_non_auto=0, edited_objects=1, edits=1, expert='Да', fielddate='2021-01-12',
               geo_path='\t10000\t', link=1, moderator=None, object_path='\t_total_\trd_group\trd_el\t', session=0,
               sum_right_cart_res=0, sum_total_cart_res=0,
               user_path='\t_total_\tyandex\tyandex-moderator\ttest_1 (1)\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=2, as_mod_obj=2, auto_hard=0, auto_simple=0,
               count_uniq_task_id=2, edited_non_auto=0, edited_objects=2, edits=2, expert='Да', fielddate='2021-01-12',
               geo_path='\t10000\t', link=2, moderator='Да', object_path='\t_total_\t', session=0.25,
               sum_right_cart_res=1, sum_total_cart_res=1, user_path='\t_total_\t'),
        Record(action_path='\t_total_\tobject-modified\t', as_mod=2, as_mod_obj=2, auto_hard=0, auto_simple=0,
               count_uniq_task_id=2, edited_non_auto=0, edited_objects=2, edits=2, expert='Да', fielddate='2021-01-12',
               geo_path='\t10000\t', link=2, moderator='Да', object_path='\t_total_\t', session=0.25,
               sum_right_cart_res=1, sum_total_cart_res=1, user_path='\t_total_\tyandex\t')
    ])
