import common
from nile.api.v1 import (
    local,
    Record
)
import maps.wikimap.stat.nmaps_count_resolved_users.lib.edits_constants as edits_constants


def test_create_category_groups_dict():
    define_category_groups_dict = {
        'rd': 'rd_group',
        'rd_el': 'rd_group',
        'rd_jc': 'rd_group',
        'cond': 'cond_group',
        'cond_annotation': 'cond_group',
        'cond_cam': 'cond_group',
        'ad': 'ad_group',
        'ad_subst': 'ad_group',
        'ad_cnt': 'ad_group',
        'ad_jc': 'ad_group',
        'bld': 'bld_group',
        'bld_complex': 'bld_group',
    }

    test_xml_string = '''<?xml version="1.0" encoding="UTF-8"?>
<category-groups xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="categories.xsd">
    <category-group id="rd_group" ugc_valuable="true">
        <label>{{category-groups:rd_group}}</label>
        <categories>
            <category id="rd"/>
            <category id="rd_el"/>
            <category id="rd_jc"/>
        </categories>
    </category-group>
    <category-group id="cond_group" ugc_valuable="true">
        <label>{{category-groups:cond_group}}</label>
        <categories>
            <category id="cond"/>
            <category id="cond_annotation"/>
            <category id="cond_cam"/>
        </categories>
    </category-group>
    <category-group id="ad_group" ugc_valuable="true">
        <label>{{category-groups:ad_group}}</label>
        <categories>
            <category id="ad"/>
            <category id="ad_subst"/>
            <category id="ad_cnt"/>
            <category id="ad_jc"/>
        </categories>
    </category-group>
    <category-group id="bld_group" ugc_valuable="true">
        <label>{{category-groups:bld_group}}</label>
        <categories>
            <category id="bld"/>
            <category id="bld_complex"/>
        </categories>
    </category-group>
</category-groups>'''

    assert define_category_groups_dict == edits_constants.create_category_groups_dict(test_xml_string)


def test_add_path_add_user_status(statface_client, job, geobase_fixture):
    job = common.make_count_job(statface_client, job)

    moderation_tasks = [
        Record(
            puid=1, task_id=1, object_category='rd_el', event_type='edit', region_id='213', fielddate='2021-01-12'
        ),
        Record(
            puid=2, task_id=2, object_category='ad', event_type='request-for-deletion', region_id='213', fielddate='2021-01-12'
        )
    ]
    nmaps_user_raw = [
        Record(
            puid=1, moderation_status='yandex-moderator'
        ),
        Record(
            puid=2, moderation_status='cartographer'
        )
    ]

    create_object_path = []
    create_event_path = []
    moderation_with_paths = []

    job.local_run(
        sources={
            'moderation_tasks': local.StreamSource(moderation_tasks),
            'nmaps_user_raw': local.StreamSource(nmaps_user_raw)
        },
        sinks={
            'create_object_path': local.ListSink(create_object_path),
            'create_event_path': local.ListSink(create_event_path),
            'moderation_with_paths': local.ListSink(moderation_with_paths)
        }
    )

    assert sorted(create_object_path) == sorted([
        Record(event_type='edit', fielddate='2021-01-12', object_path='\t_total_\t', puid=1, region_id='213',
               task_id=1),
        Record(event_type='edit', fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1, region_id='213',
               task_id=1),
        Record(event_type='edit', fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t', puid=1,
               region_id='213', task_id=1),
        Record(event_type='request-for-deletion', fielddate='2021-01-12', object_path='\t_total_\t', puid=2,
               region_id='213', task_id=2),
        Record(event_type='request-for-deletion', fielddate='2021-01-12', object_path='\t_total_\tad_group\t', puid=2,
               region_id='213', task_id=2),
        Record(event_type='request-for-deletion', fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t',
               puid=2, region_id='213', task_id=2)
    ])

    assert sorted(create_event_path) == sorted([
        Record(event_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\t', puid=1, region_id='213',
               task_id=1),
        Record(event_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\t', puid=2, region_id='213',
               task_id=2),
        Record(event_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\tad_group\t', puid=2,
               region_id='213', task_id=2),
        Record(event_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t', puid=2,
               region_id='213', task_id=2),
        Record(event_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               region_id='213', task_id=1),
        Record(event_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t', puid=1,
               region_id='213', task_id=1),
        Record(event_path='\t_total_\tedit\t', fielddate='2021-01-12', object_path='\t_total_\t', puid=1,
               region_id='213', task_id=1),
        Record(event_path='\t_total_\tedit\t', fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               region_id='213', task_id=1),
        Record(event_path='\t_total_\tedit\t', fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t',
               puid=1, region_id='213', task_id=1),
        Record(event_path='\t_total_\trequest-for-deletion\t', fielddate='2021-01-12', object_path='\t_total_\t',
               puid=2, region_id='213', task_id=2),
        Record(event_path='\t_total_\trequest-for-deletion\t', fielddate='2021-01-12',
               object_path='\t_total_\tad_group\t', puid=2, region_id='213', task_id=2),
        Record(event_path='\t_total_\trequest-for-deletion\t', fielddate='2021-01-12',
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', task_id=2)
    ])

    assert sorted(moderation_with_paths) == sorted([
        Record(event_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\t', puid=1, region_id='213',
               task_id=1, user_status='yandex-moderator'),
        Record(event_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\t', puid=2, region_id='213',
               task_id=2, user_status='cartographer'),
        Record(event_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\tad_group\t', puid=2,
               region_id='213', task_id=2, user_status='cartographer'),
        Record(event_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t', puid=2,
               region_id='213', task_id=2, user_status='cartographer'),
        Record(event_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               region_id='213', task_id=1, user_status='yandex-moderator'),
        Record(event_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t', puid=1,
               region_id='213', task_id=1, user_status='yandex-moderator'),
        Record(event_path='\t_total_\tedit\t', fielddate='2021-01-12', object_path='\t_total_\t', puid=1,
               region_id='213', task_id=1, user_status='yandex-moderator'),
        Record(event_path='\t_total_\tedit\t', fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               region_id='213', task_id=1, user_status='yandex-moderator'),
        Record(event_path='\t_total_\tedit\t', fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t',
               puid=1, region_id='213', task_id=1, user_status='yandex-moderator'),
        Record(event_path='\t_total_\trequest-for-deletion\t', fielddate='2021-01-12', object_path='\t_total_\t',
               puid=2, region_id='213', task_id=2, user_status='cartographer'),
        Record(event_path='\t_total_\trequest-for-deletion\t', fielddate='2021-01-12', user_status='cartographer',
               object_path='\t_total_\tad_group\t', puid=2, region_id='213', task_id=2),
        Record(event_path='\t_total_\trequest-for-deletion\t', fielddate='2021-01-12', user_status='cartographer',
               object_path='\t_total_\tad_group\tad\t', puid=2, region_id='213', task_id=2)
    ])


def test_prepare_result_counts(statface_client, job, major_regions, geobase_fixture):
    job = common.make_count_job(statface_client, job)

    add_region_tree = [
        Record(puid=1, task_id=1, event_path='\ttotal\t', region_tree='\t1000\t', fielddate='2021-01-12',
               object_path='\ttotal\t', user_status=b'yandex-moderator'),
        Record(puid=1, task_id=1, event_path='\ttotal\t', region_tree='\t1000\t', fielddate='2021-01-12',
               object_path='\ttotal\trd_group\t', user_status=b'yandex-moderator'),
        Record(puid=1, task_id=1, event_path='\ttotal\t', region_tree='\t1000\t', fielddate='2021-01-12',
               object_path='\ttotal\trd_group\trd_el\t', user_status=b'yandex-moderator'),
        Record(puid=2, task_id=2, event_path='\ttotal\t', region_tree='\t1000\t', fielddate='2021-01-12',
               object_path='\ttotal\t', user_status=b'cartographer'),
        Record(puid=2, task_id=2, event_path='\ttotal\t', region_tree='\t1000\t', fielddate='2021-01-12',
               object_path='\ttotal\tad_group\t', user_status=b'cartographer'),
        Record(puid=2, task_id=2, event_path='\ttotal\t', region_tree='\t1000\t', fielddate='2021-01-12',
               object_path='\ttotal\tad_group\tad\t', user_status=b'cartographer'),
        Record(puid=1, task_id=1, event_path='\ttotal\tedit\t', region_tree='\t1000\t', fielddate='2021-01-12',
               object_path='\ttotal\t', user_status=b'yandex-moderator'),
        Record(puid=1, task_id=1, event_path='\ttotal\tedit\t', region_tree='\t1000\t', fielddate='2021-01-12',
               object_path='\ttotal\trd_group\t', user_status=b'yandex-moderator'),
        Record(puid=1, task_id=1, event_path='\ttotal\tedit\t', region_tree='\t1000\t', fielddate='2021-01-12',
               object_path='\ttotal\trd_group\trd_el\t', user_status=b'yandex-moderator'),
        Record(puid=2, task_id=2, event_path='\ttotal\trequest-for-deletion\t', region_tree='\t1000\t',
               fielddate='2021-01-12', object_path='\ttotal\t', user_status=b'cartographer'),
        Record(puid=2, task_id=2, event_path='\ttotal\trequest-for-deletion\t', region_tree='\t1000\t',
               fielddate='2021-01-12', object_path='\ttotal\tad_group\tad\t', user_status=b'cartographer'),
        Record(puid=1, task_id=1, event_path='\ttotal\t', region_tree='\t1000\t225\t', fielddate='2021-01-12',
               object_path='\ttotal\t', user_status=b'yandex-moderator'),
        Record(puid=1, task_id=1, event_path='\ttotal\t', region_tree='\t1000\t225\t', fielddate='2021-01-12',
               object_path='\ttotal\trd_group\t', user_status=b'yandex-moderator'),
        Record(puid=1, task_id=1, event_path='\ttotal\t', region_tree='\t1000\t225\t', fielddate='2021-01-12',
               object_path='\ttotal\trd_group\trd_el\t', user_status=b'yandex-moderator'),
        Record(puid=2, task_id=2, event_path='\ttotal\t', region_tree='\t1000\t225\t', fielddate='2021-01-12',
               object_path='\ttotal\t', user_status=b'cartographer'),
        Record(puid=2, task_id=2, event_path='\ttotal\t', region_tree='\t1000\t225\t', fielddate='2021-01-12',
               object_path='\ttotal\tad_group\t', user_status=b'cartographer'),
        Record(puid=2, task_id=2, event_path='\ttotal\t', region_tree='\t1000\t225\t', fielddate='2021-01-12',
               object_path='\ttotal\tad_group\tad\t', user_status=b'cartographer'),
        Record(puid=1, task_id=1, event_path='\ttotal\tedit\t', region_tree='\t1000\t225\t', fielddate='2021-01-12',
               object_path='\ttotal\t', user_status=b'yandex-moderator'),
        Record(puid=1, task_id=1, event_path='\ttotal\tedit\t', region_tree='\t1000\t225\t', fielddate='2021-01-12',
               object_path='\ttotal\trd_group\t', user_status=b'yandex-moderator'),
        Record(puid=1, task_id=1, event_path='\ttotal\tedit\t', region_tree='\t1000\t225\t', fielddate='2021-01-12',
               object_path='\ttotal\trd_group\trd_el\t', user_status=b'yandex-moderator'),
        Record(puid=2, task_id=2, event_path='\ttotal\trequest-for-deletion\t', region_tree='\t1000\t225\t',
               fielddate='2021-01-12', object_path='\ttotal\t', user_status=b'cartographer'),
        Record(uid=2, task_id=2, event_path='\ttotal\trequest-for-deletion\t', region_tree='\t1000\t225\t',
               fielddate='2021-01-12', object_path='\ttotal\tad_group\t', user_status=b'cartographer'),
        Record(puid=2, task_id=2, event_path='\ttotal\trequest-for-deletion\t', region_tree='\t1000\t225\t',
               fielddate='2021-01-12', object_path='\ttotal\tad_group\tad\t', user_status=b'cartographer'),
        Record(puid=1, task_id=1, event_path='\ttotal\t', region_tree='\t1000\t225\t3\t213\t', fielddate='2021-01-12',
               object_path='\ttotal\t', user_status=b'yandex-moderator'),
        Record(puid=1, task_id=1, event_path='\ttotal\t', region_tree='\t1000\t225\t3\t213\t', fielddate='2021-01-12',
               object_path='\ttotal\trd_group\t', user_status=b'yandex-moderator'),
        Record(puid=1, task_id=1, event_path='\ttotal\t', region_tree='\t1000\t225\t3\t213\t', fielddate='2021-01-12',
               object_path='\ttotal\trd_group\trd_el\t', user_status=b'yandex-moderator'),
        Record(puid=2, task_id=2, event_path='\ttotal\t', region_tree='\t1000\t225\t3\t213\t', fielddate='2021-01-12',
               object_path='\ttotal\t', user_status=b'cartographer'),
        Record(puid=2, task_id=2, event_path='\ttotal\t', region_tree='\t1000\t225\t3\t213\t', fielddate='2021-01-12',
               object_path='\ttotal\tad_group\t', user_status=b'cartographer'),
        Record(puid=2, task_id=2, event_path='\ttotal\t', region_tree='\t1000\t225\t3\t213\t', fielddate='2021-01-12',
               object_path='\ttotal\tad_group\tad\t', user_status=b'cartographer'),
        Record(puid=1, task_id=1, event_path='\ttotal\tedit\t', region_tree='\t1000\t225\t3\t213\t',
               fielddate='2021-01-12', object_path='\ttotal\t', user_status=b'yandex-moderator'),
        Record(puid=1, task_id=1, event_path='\ttotal\tedit\t', region_tree='\t1000\t225\t3\t213\t',
               fielddate='2021-01-12', object_path='\ttotal\trd_group\t', user_status=b'yandex-moderator'),
        Record(puid=1, task_id=1, event_path='\ttotal\tedit\t', region_tree='\t1000\t225\t3\t213\t',
               fielddate='2021-01-12', object_path='\ttotal\trd_group\trd_el\t', user_status=b'yandex-moderator'),
        Record(puid=2, task_id=2, event_path='\ttotal\trequest-for-deletion\t', region_tree='\t1000\t225\t3\t213\t',
               fielddate='2021-01-12', object_path='\ttotal\t', user_status=b'cartographer'),
        Record(puid=2, task_id=2, event_path='\ttotal\trequest-for-deletion\t', region_tree='\t1000\t225\t3\t213\t',
               fielddate='2021-01-12', object_path='\ttotal\tad_group\t', user_status=b'cartographer'),
        Record(puid=2, task_id=2, event_path='\ttotal\trequest-for-deletion\t', region_tree='\t1000\t225\t3\t213\t',
               fielddate='2021-01-12', object_path='\ttotal\tad_group\tad\t', user_status=b'cartographer')
    ]

    aggregate_by_task_id = []
    aggregate_by_moderator = []
    aggregate_by_yandex_moderator = []
    aggregate_by_cartographer = []
    prepare_result_counts = []

    job.local_run(
        sources={
            'add_region_tree': local.StreamSource(add_region_tree),
            'major_regions': local.StreamSource(major_regions)
        },
        sinks={
            'aggregate_by_task_id': local.ListSink(aggregate_by_task_id),
            'aggregate_by_moderator': local.ListSink(aggregate_by_moderator),
            'aggregate_by_yandex_moderator': local.ListSink(aggregate_by_yandex_moderator),
            'aggregate_by_cartographer': local.ListSink(aggregate_by_cartographer),
            'prepare_result_counts': local.ListSink(prepare_result_counts)
        }
    )

    assert sorted(aggregate_by_task_id) == sorted([
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\t', region_tree='\t1000\t',
               sum_mod_task=2),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\t', region_tree='\t1000\t225\t',
               sum_mod_task=2),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\t',
               region_tree='\t1000\t225\t3\t213\t', sum_mod_task=2),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\t',
               region_tree='\t1000\t', sum_mod_task=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\t',
               region_tree='\t1000\t225\t', sum_mod_task=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\t',
               region_tree='\t1000\t225\t3\t213\t', sum_mod_task=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\tad\t',
               region_tree='\t1000\t', sum_mod_task=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\tad\t',
               region_tree='\t1000\t225\t', sum_mod_task=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\tad\t',
               region_tree='\t1000\t225\t3\t213\t', sum_mod_task=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\t',
               region_tree='\t1000\t', sum_mod_task=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\t',
               region_tree='\t1000\t225\t', sum_mod_task=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\t',
               region_tree='\t1000\t225\t3\t213\t', sum_mod_task=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\trd_el\t',
               region_tree='\t1000\t', sum_mod_task=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\trd_el\t',
               region_tree='\t1000\t225\t', sum_mod_task=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\trd_el\t',
               region_tree='\t1000\t225\t3\t213\t', sum_mod_task=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\t', region_tree='\t1000\t',
               sum_mod_task=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\t',
               region_tree='\t1000\t225\t', sum_mod_task=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\t',
               region_tree='\t1000\t225\t3\t213\t', sum_mod_task=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\t',
               region_tree='\t1000\t', sum_mod_task=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\t',
               region_tree='\t1000\t225\t', sum_mod_task=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\t',
               region_tree='\t1000\t225\t3\t213\t', sum_mod_task=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\trd_el\t',
               region_tree='\t1000\t', sum_mod_task=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\trd_el\t',
               region_tree='\t1000\t225\t', sum_mod_task=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\trd_el\t',
               region_tree='\t1000\t225\t3\t213\t', sum_mod_task=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', object_path='\ttotal\t',
               region_tree='\t1000\t', sum_mod_task=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', object_path='\ttotal\t',
               region_tree='\t1000\t225\t', sum_mod_task=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', object_path='\ttotal\t',
               region_tree='\t1000\t225\t3\t213\t', sum_mod_task=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\t',
               region_tree='\t1000\t225\t', sum_mod_task=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\t',
               region_tree='\t1000\t225\t3\t213\t', sum_mod_task=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12',
               object_path='\ttotal\tad_group\tad\t', region_tree='\t1000\t', sum_mod_task=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12',
               object_path='\ttotal\tad_group\tad\t', region_tree='\t1000\t225\t', sum_mod_task=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12',
               object_path='\ttotal\tad_group\tad\t', region_tree='\t1000\t225\t3\t213\t', sum_mod_task=1)
    ])

    assert sorted(aggregate_by_moderator) == sorted([])

    assert sorted(aggregate_by_yandex_moderator) == sorted([
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\t', region_tree='\t1000\t',
               sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\t', region_tree='\t1000\t225\t',
               sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\t',
               region_tree='\t1000\t225\t3\t213\t', sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\t',
               region_tree='\t1000\t', sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\t',
               region_tree='\t1000\t225\t', sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\t',
               region_tree='\t1000\t225\t3\t213\t', sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\trd_el\t',
               region_tree='\t1000\t', sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\trd_el\t',
               region_tree='\t1000\t225\t', sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\trd_el\t',
               region_tree='\t1000\t225\t3\t213\t', sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\t', region_tree='\t1000\t',
               sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\t',
               region_tree='\t1000\t225\t', sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\t',
               region_tree='\t1000\t225\t3\t213\t', sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\t',
               region_tree='\t1000\t', sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\t',
               region_tree='\t1000\t225\t', sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\t',
               region_tree='\t1000\t225\t3\t213\t', sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\trd_el\t',
               region_tree='\t1000\t', sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\trd_el\t',
               region_tree='\t1000\t225\t', sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', object_path='\ttotal\trd_group\trd_el\t',
               region_tree='\t1000\t225\t3\t213\t', sum_yandex_moderator=1)
    ])

    assert sorted(aggregate_by_cartographer) == sorted([
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\t', region_tree='\t1000\t',
               sum_cartographer=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\t', region_tree='\t1000\t225\t',
               sum_cartographer=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\t',
               region_tree='\t1000\t225\t3\t213\t', sum_cartographer=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\t',
               region_tree='\t1000\t', sum_cartographer=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\t',
               region_tree='\t1000\t225\t', sum_cartographer=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\t',
               region_tree='\t1000\t225\t3\t213\t', sum_cartographer=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\tad\t',
               region_tree='\t1000\t', sum_cartographer=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\tad\t',
               region_tree='\t1000\t225\t', sum_cartographer=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\tad\t',
               region_tree='\t1000\t225\t3\t213\t', sum_cartographer=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', object_path='\ttotal\t',
               region_tree='\t1000\t', sum_cartographer=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', object_path='\ttotal\t',
               region_tree='\t1000\t225\t', sum_cartographer=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', object_path='\ttotal\t',
               region_tree='\t1000\t225\t3\t213\t', sum_cartographer=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\t',
               region_tree='\t1000\t225\t', sum_cartographer=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', object_path='\ttotal\tad_group\t',
               region_tree='\t1000\t225\t3\t213\t', sum_cartographer=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12',
               object_path='\ttotal\tad_group\tad\t', region_tree='\t1000\t', sum_cartographer=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12',
               object_path='\ttotal\tad_group\tad\t', region_tree='\t1000\t225\t', sum_cartographer=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12',
               object_path='\ttotal\tad_group\tad\t', region_tree='\t1000\t225\t3\t213\t', sum_cartographer=1)
    ])

    assert sorted(prepare_result_counts) == sorted([
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t', object_path='\ttotal\t',
               sum_cartographer=1, sum_mod_task=2, sum_moderator=0, sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t', object_path='\ttotal\tad_group\t',
               sum_cartographer=1, sum_mod_task=1, sum_moderator=0, sum_yandex_moderator=0),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t',
               object_path='\ttotal\tad_group\tad\t', sum_cartographer=1, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=0),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t', object_path='\ttotal\trd_group\t',
               sum_cartographer=0, sum_mod_task=1, sum_moderator=0, sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t',
               object_path='\ttotal\trd_group\trd_el\t', sum_cartographer=0, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t225\t', object_path='\ttotal\t',
               sum_cartographer=1, sum_mod_task=2, sum_moderator=0, sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t225\t',
               object_path='\ttotal\tad_group\t', sum_cartographer=1, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=0),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t225\t',
               object_path='\ttotal\tad_group\tad\t', sum_cartographer=1, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=0),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t225\t',
               object_path='\ttotal\trd_group\t', sum_cartographer=0, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t225\t',
               object_path='\ttotal\trd_group\trd_el\t', sum_cartographer=0, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t225\t3\t213\t',
               object_path='\ttotal\t', sum_cartographer=1, sum_mod_task=2, sum_moderator=0, sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t225\t3\t213\t',
               object_path='\ttotal\tad_group\t', sum_cartographer=1, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=0),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t225\t3\t213\t',
               object_path='\ttotal\tad_group\tad\t', sum_cartographer=1, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=0),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t225\t3\t213\t',
               object_path='\ttotal\trd_group\t', sum_cartographer=0, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=1),
        Record(event_path='\ttotal\t', fielddate='2021-01-12', geo_path='\t1000\t225\t3\t213\t',
               object_path='\ttotal\trd_group\trd_el\t', sum_cartographer=0, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', geo_path='\t1000\t', object_path='\ttotal\t',
               sum_cartographer=0, sum_mod_task=1, sum_moderator=0, sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', geo_path='\t1000\t',
               object_path='\ttotal\trd_group\t', sum_cartographer=0, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', geo_path='\t1000\t',
               object_path='\ttotal\trd_group\trd_el\t', sum_cartographer=0, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', geo_path='\t1000\t225\t', object_path='\ttotal\t',
               sum_cartographer=0, sum_mod_task=1, sum_moderator=0, sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', geo_path='\t1000\t225\t',
               object_path='\ttotal\trd_group\t', sum_cartographer=0, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', geo_path='\t1000\t225\t',
               object_path='\ttotal\trd_group\trd_el\t', sum_cartographer=0, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', geo_path='\t1000\t225\t3\t213\t',
               object_path='\ttotal\t', sum_cartographer=0, sum_mod_task=1, sum_moderator=0, sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', geo_path='\t1000\t225\t3\t213\t',
               object_path='\ttotal\trd_group\t', sum_cartographer=0, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=1),
        Record(event_path='\ttotal\tedit\t', fielddate='2021-01-12', geo_path='\t1000\t225\t3\t213\t',
               object_path='\ttotal\trd_group\trd_el\t', sum_cartographer=0, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=1),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', geo_path='\t1000\t',
               object_path='\ttotal\t', sum_cartographer=1, sum_mod_task=1, sum_moderator=0, sum_yandex_moderator=0),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', geo_path='\t1000\t',
               object_path='\ttotal\tad_group\tad\t', sum_cartographer=1, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=0),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', geo_path='\t1000\t225\t',
               object_path='\ttotal\t', sum_cartographer=1, sum_mod_task=1, sum_moderator=0, sum_yandex_moderator=0),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', geo_path='\t1000\t225\t',
               object_path='\ttotal\tad_group\t', sum_cartographer=1, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=0),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', geo_path='\t1000\t225\t',
               object_path='\ttotal\tad_group\tad\t', sum_cartographer=1, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=0),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', geo_path='\t1000\t225\t3\t213\t',
               object_path='\ttotal\t', sum_cartographer=1, sum_mod_task=1, sum_moderator=0, sum_yandex_moderator=0),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', geo_path='\t1000\t225\t3\t213\t',
               object_path='\ttotal\tad_group\t', sum_cartographer=1, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=0),
        Record(event_path='\ttotal\trequest-for-deletion\t', fielddate='2021-01-12', geo_path='\t1000\t225\t3\t213\t',
               object_path='\ttotal\tad_group\tad\t', sum_cartographer=1, sum_mod_task=1, sum_moderator=0,
               sum_yandex_moderator=0)
    ])
