import xml.dom.minidom as minidom
from library.python import resource


def create_category_groups_dict(xml_string):
    '''
    Parse maps/wikimap/mapspro/cfg/editor/category_groups.xml and creating
    DEFINE_CATEGORY_GROUPS_DICT={
        'rd': 'rd_group',
        'rd_el': 'rd_group',
        'ad_el': 'ad_group',
        ...
    }
    '''
    category_dict = {}
    filexml = minidom.parseString(xml_string)
    filexml.normalize()

    for category_group_el in filexml.getElementsByTagName('category-group'):
        category_group_name = category_group_el.getAttribute("id")
        for category_el in category_group_el.childNodes:
            if category_el.nodeName == 'categories':
                for category in category_el.getElementsByTagName('category'):
                    category_dict[category.getAttribute('id')] = category_group_name
    return category_dict


DEFINE_CATEGORY_GROUPS_DICT = create_category_groups_dict(resource.find('category_groups_xml'))
