import datetime
from maps.pylibs.utils.lib.common import require
import maps.wikimap.stat.libs.common.lib.cli_options as cli_opts


JOB_OPTIONS = [
    cli_opts.results_option()
]


def extract_fielddate(options):
    '''
    Checking options.dates.
    Do not use today for manually launch
    '''
    options_date = cli_opts.get_single_date(options)

    require(
        options_date < datetime.date.today().isoformat(),
        RuntimeError('Do not use today in --dates parameter')
    )

    return options_date
