import common
from nile.api.v1 import (
    local,
    Record
)
import maps.wikimap.stat.nmaps_count_revert_reason.lib.edits_constants as edits_constants


def test_create_category_groups_dict():
    define_category_groups_dict = {
        'rd': 'rd_group',
        'rd_el': 'rd_group',
        'rd_jc': 'rd_group',
        'cond': 'cond_group',
        'cond_annotation': 'cond_group',
        'cond_cam': 'cond_group',
        'ad': 'ad_group',
        'ad_subst': 'ad_group',
        'ad_cnt': 'ad_group',
        'ad_jc': 'ad_group',
        'bld': 'bld_group',
        'bld_complex': 'bld_group',
    }

    test_xml_string = '''<?xml version="1.0" encoding="UTF-8"?>
<category-groups xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="categories.xsd">
    <category-group id="rd_group" ugc_valuable="true">
        <label>{{category-groups:rd_group}}</label>
        <categories>
            <category id="rd"/>
            <category id="rd_el"/>
            <category id="rd_jc"/>
        </categories>
    </category-group>
    <category-group id="cond_group" ugc_valuable="true">
        <label>{{category-groups:cond_group}}</label>
        <categories>
            <category id="cond"/>
            <category id="cond_annotation"/>
            <category id="cond_cam"/>
        </categories>
    </category-group>
    <category-group id="ad_group" ugc_valuable="true">
        <label>{{category-groups:ad_group}}</label>
        <categories>
            <category id="ad"/>
            <category id="ad_subst"/>
            <category id="ad_cnt"/>
            <category id="ad_jc"/>
        </categories>
    </category-group>
    <category-group id="bld_group" ugc_valuable="true">
        <label>{{category-groups:bld_group}}</label>
        <categories>
            <category id="bld"/>
            <category id="bld_complex"/>
        </categories>
    </category-group>
</category-groups>'''

    assert define_category_groups_dict == edits_constants.create_category_groups_dict(test_xml_string)


def test_add_path_add(statface_client, job):
    job = common.make_count_job(statface_client, job)

    revert_reason = [
        Record(
            puid=1, commit_id=1, object_category='rd_el', revert_reason='vandalism', fielddate='2021-01-12'
        ),
        Record(
            puid=2, commit_id=2, object_category='ad', revert_reason='incorrect-object-category', fielddate='2021-01-12'
        )
    ]
    nmaps_user_raw = [
        Record(
            puid=1, moderation_status='yandex-moderator'
        ),
        Record(
            puid=2, moderation_status='cartographer'
        )
    ]

    create_object_path = []
    create_revert_path = []
    revert_reason_with_paths = []

    job.local_run(
        sources={
            'revert_reason': local.StreamSource(revert_reason),
            'nmaps_user_raw': local.StreamSource(nmaps_user_raw)
        },
        sinks={
            'create_object_path': local.ListSink(create_object_path),
            'create_revert_path': local.ListSink(create_revert_path),
            'revert_reason_with_paths': local.ListSink(revert_reason_with_paths)
        }
    )

    assert sorted(create_object_path) == sorted([
        Record(revert_reason='vandalism', fielddate='2021-01-12', object_path='\t_total_\t', puid=1, commit_id=1),
        Record(revert_reason='vandalism', fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               commit_id=1),
        Record(revert_reason='vandalism', fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t', puid=1,
               commit_id=1),
        Record(revert_reason='incorrect-object-category', fielddate='2021-01-12', object_path='\t_total_\t',
               puid=2, commit_id=2),
        Record(revert_reason='incorrect-object-category', fielddate='2021-01-12', object_path='\t_total_\tad_group\t',
               puid=2, commit_id=2),
        Record(revert_reason='incorrect-object-category', fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t',
               puid=2, commit_id=2)
    ])

    assert sorted(create_revert_path) == sorted([
        Record(revert_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\t', puid=1, commit_id=1),
        Record(revert_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\t', puid=2, commit_id=2),
        Record(revert_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\tad_group\t', puid=2,
               commit_id=2),
        Record(revert_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t', puid=2,
               commit_id=2),
        Record(revert_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               commit_id=1),
        Record(revert_path='\t_total_\t', fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t', puid=1,
               commit_id=1),
        Record(revert_path='\t_total_\tvandalism\t', fielddate='2021-01-12', object_path='\t_total_\t', puid=1,
               commit_id=1),
        Record(revert_path='\t_total_\tvandalism\t', fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               commit_id=1),
        Record(revert_path='\t_total_\tvandalism\t', fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t',
               puid=1, commit_id=1),
        Record(revert_path='\t_total_\tincorrect-object-category\t', fielddate='2021-01-12', object_path='\t_total_\t',
               puid=2, commit_id=2),
        Record(revert_path='\t_total_\tincorrect-object-category\t', fielddate='2021-01-12',
               object_path='\t_total_\tad_group\t', puid=2, commit_id=2),
        Record(revert_path='\t_total_\tincorrect-object-category\t', fielddate='2021-01-12',
               object_path='\t_total_\tad_group\tad\t', puid=2, commit_id=2)
    ])

    assert sorted(revert_reason_with_paths) == sorted([
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\t', puid=1, revert_path='\t_total_\t',
               status_path='\t_total_\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\t', puid=1, revert_path='\t_total_\t',
               status_path='\t_total_\tyandex-moderator\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\t', puid=1,
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\t', puid=1,
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               revert_path='\t_total_\t', status_path='\t_total_\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               revert_path='\t_total_\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t', puid=1,
               revert_path='\t_total_\t', status_path='\t_total_\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t', puid=1,
               revert_path='\t_total_\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t', puid=1,
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t', puid=1,
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\t', puid=2, revert_path='\t_total_\t',
               status_path='\t_total_\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\t', puid=2, revert_path='\t_total_\t',
               status_path='\t_total_\tcartographer\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\t', puid=2,
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\t', puid=2,
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\tcartographer\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\t', puid=2,
               revert_path='\t_total_\t', status_path='\t_total_\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\t', puid=2,
               revert_path='\t_total_\t', status_path='\t_total_\tcartographer\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\t', puid=2,
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\t', puid=2,
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\tcartographer\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t', puid=2,
               revert_path='\t_total_\t', status_path='\t_total_\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t', puid=2,
               revert_path='\t_total_\t', status_path='\t_total_\tcartographer\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t', puid=2,
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t', puid=2,
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\tcartographer\t')
    ])


def test_prepare_result_counts(statface_client, job):
    job = common.make_count_job(statface_client, job)

    revert_reason_with_paths = [
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\t', puid=1, revert_path='\t_total_\t',
               status_path='\t_total_\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\t', puid=1, revert_path='\t_total_\t',
               status_path='\t_total_\tyandex-moderator\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\t', puid=1,
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\t', puid=1,
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               revert_path='\t_total_\t', status_path='\t_total_\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               revert_path='\t_total_\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\t', puid=1,
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t', puid=1,
               revert_path='\t_total_\t', status_path='\t_total_\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t', puid=1,
               revert_path='\t_total_\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t', puid=1,
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\t'),
        Record(commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t', puid=1,
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\t', puid=2, revert_path='\t_total_\t',
               status_path='\t_total_\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\t', puid=2, revert_path='\t_total_\t',
               status_path='\t_total_\tcartographer\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\t', puid=2,
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\t', puid=2,
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\tcartographer\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\t', puid=2,
               revert_path='\t_total_\t', status_path='\t_total_\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\t', puid=2,
               revert_path='\t_total_\t', status_path='\t_total_\tcartographer\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\t', puid=2,
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\t', puid=2,
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\tcartographer\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t', puid=2,
               revert_path='\t_total_\t', status_path='\t_total_\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t', puid=2,
               revert_path='\t_total_\t', status_path='\t_total_\tcartographer\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t', puid=2,
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\t'),
        Record(commit_id=2, fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t', puid=2,
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\tcartographer\t')
    ]

    prepare_result_counts = []

    job.local_run(
        sources={
            'revert_reason_with_paths': local.StreamSource(revert_reason_with_paths)
        },
        sinks={
            'prepare_result_counts': local.ListSink(prepare_result_counts)
        }
    )

    assert sorted(prepare_result_counts) == sorted([
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\t', revert_path='\t_total_\t',
               status_path='\t_total_\tcartographer\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\t', revert_path='\t_total_\t',
               status_path='\t_total_\tyandex-moderator\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\t',
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\t',
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\tcartographer\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\t',
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\t',
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\tad_group\t',
               revert_path='\t_total_\t', status_path='\t_total_\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\tad_group\t',
               revert_path='\t_total_\t', status_path='\t_total_\tcartographer\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\tad_group\t',
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\tad_group\t',
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\tcartographer\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t',
               revert_path='\t_total_\t', status_path='\t_total_\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t',
               revert_path='\t_total_\t', status_path='\t_total_\tcartographer\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t',
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\tad_group\tad\t',
               revert_path='\t_total_\tincorrect-object-category\t', status_path='\t_total_\tcartographer\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\t',
               revert_path='\t_total_\t', status_path='\t_total_\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\t',
               revert_path='\t_total_\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\t',
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\t',
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t',
               revert_path='\t_total_\t', status_path='\t_total_\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t',
               revert_path='\t_total_\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t',
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\t'),
        Record(count_uniq_commit_id=1, fielddate='2021-01-12', object_path='\t_total_\trd_group\trd_el\t',
               revert_path='\t_total_\tvandalism\t', status_path='\t_total_\tyandex-moderator\t'),
        Record(count_uniq_commit_id=2, fielddate='2021-01-12', object_path='\t_total_\t', revert_path='\t_total_\t',
               status_path='\t_total_\t')
    ])
