from nile.api.v1 import (
    clusters,
    statface,
    Record
)
import pytest


@pytest.fixture
def statface_client():
    return statface.client.MockStatfaceClient()


@pytest.fixture
def job():
    cluster = clusters.MockCluster()
    return cluster.job()


@pytest.fixture
def major_regions():
    return [
        Record(region_id='10000',  major_id='10000', region_tree='\t10000\t'),

        # Россия, Москва
        Record(region_id='213', major_id='10000', region_tree="\t10000\t"),
        Record(region_id='213', major_id='225', region_tree="\t10000\t225\t"),
        Record(region_id='213', major_id='3', region_tree="\t10000\t225\t3\t"),
        Record(region_id='213', major_id='1', region_tree="\t10000\t225\t3\t1\t"),
        Record(region_id='213', major_id='213', region_tree="\t10000\t225\t3\t1\t213\t"),
        Record(region_id='213', major_id='999999001', region_tree="\t10000\t225\t999999001\t"),
        Record(region_id='213', major_id='213', region_tree="\t10000\t225\t999999001\t213\t"),
    ]
