import common
from nile.api.v1 import (
    local,
    Record
)


def test_create_user_path(statface_client, job):
    job = common.make_count_job(statface_client, job)

    edits_count_per_user = [
        Record(date='2020-07-26', edits=100, puid='1'),
        Record(date='2020-07-26', edits=15, puid='2')
    ]
    nmaps_user_raw = [
        Record(puid='1', moderation_status='moderator'),
        Record(puid='2', moderation_status='cartographer'),
    ]

    create_user_path = []

    job.local_run(
        sources={
            'edits_count_per_user': local.StreamSource(edits_count_per_user),
            'nmaps_user_raw': local.StreamSource(nmaps_user_raw)
        },
        sinks={
            'create_user_path': local.ListSink(create_user_path)
        }
    )

    assert sorted(create_user_path) == sorted([
        Record(puid='1', user_path='\t_total_\t'),
        Record(puid='1', user_path='\t_total_\tusers\t'),
        Record(puid='1', user_path='\t_total_\tusers\tmoderator\t'),
        Record(puid='2', user_path='\t_total_\t'),
        Record(puid='2', user_path='\t_total_\tyandex\t'),
        Record(puid='2', user_path='\t_total_\tyandex\tnew\t')
    ])


def test_create_nmaps_edits(statface_client, job):
    job = common.make_count_job(statface_client, job)

    nmaps_edit_raw = [
        Record(
            commit_id='1', iso_eventtime='2020-07-26', action='object-created',
            object_id='1', puid='1', region_tree='213'
        ),
        Record(
            commit_id='1', iso_eventtime='2020-07-26', action='object-modified',
            object_id='1', puid='1', region_tree='213'
        ),
    ]

    add_action_create = []
    nmaps_edits = []

    job.local_run(
        sources={
            'nmaps_edit_raw': local.StreamSource(nmaps_edit_raw)
        },
        sinks={
            'add_action_create': local.ListSink(add_action_create),
            'nmaps_edits': local.ListSink(nmaps_edits)
        }
    )

    assert sorted(add_action_create) == sorted([
        Record(puid='1', action_create=1),
        Record(puid='1', action_create=0)
    ])

    assert sorted(nmaps_edits) == sorted([
        Record(puid='1', action_sum_create=1)
    ])


def test_create_bebr_table(statface_client, job):
    job = common.make_count_job(statface_client, job)

    filter_bebr_log = [
        Record(
            event_type='bounds_change', path='nmaps_www.map', pid='458', puid='1',
            session_id='1', timestamp=1604713483, geo_id=213, date='2020-07-26',
            vars={
                "newBounds": [
                    [
                        146.74376299728934,
                        -19.291748663089077
                    ],
                    [
                        146.74575856079642,
                        -19.29079361083855
                    ]
                ],
                "newZoom": 20,
                "oldBounds": [
                    [
                        146.74394731678933,
                        -19.291707537604058
                    ],
                    [
                        146.74594288029638,
                        -19.29075248511075
                    ]
                ],
                "oldZoom": 20
            }
        ),
        Record(
            event_type='click', path='nmaps_www.map', pid='458', puid='1',
            session_id='1', timestamp=1604713483, geo_id=213, date='2020-07-26',
            vars={"button": "left"}
        ),
        Record(
            event_type='show', path='nmaps_www.create_geoobject.header', pid='458', puid='2',
            session_id='2', timestamp=1604713483, geo_id=213, date='2020-07-26',
            vars=None
        )
    ]

    custom_bebr_log = []

    job.local_run(
        sources={
            'filter_bebr_log': local.StreamSource(filter_bebr_log)
        },
        sinks={
            'custom_bebr_log': local.ListSink(custom_bebr_log)
        }
    )

    assert sorted(custom_bebr_log) == sorted([
        Record(click=None, date='2020-07-26', event_type='bounds_change', fielddate='2020-07-26', geo_id=213,
               path='nmaps_www.map', pid='458', puid='1', puid_click=None, region_id='213', session_click=None,
               session_id='1', shows=None, timestamp=1604713483,
               vars={'newBounds': [[146.74376299728934, -19.291748663089077], [146.74575856079642, -19.29079361083855]],
                     'newZoom': 20,
                     'oldBounds': [[146.74394731678933, -19.291707537604058], [146.74594288029638, -19.29075248511075]],
                     'oldZoom': 20}),
        Record(click=None, date='2020-07-26', event_type='show', fielddate='2020-07-26', geo_id=213,
               path='nmaps_www.create_geoobject.header', pid='458', puid='2', puid_click=None, region_id='213',
               session_click=None, session_id='2', shows=1, timestamp=1604713483, vars=None),
        Record(click=1, date='2020-07-26', event_type='click', fielddate='2020-07-26', geo_id=213, path='nmaps_www.map',
               pid='458', puid='1', puid_click='1', region_id='213', session_click='1', session_id='1', shows=None,
               timestamp=1604713483, vars={'button': 'left'})
    ])


def test_make_nmaps_edits_for_count(statface_client, job):
    job = common.make_count_job(statface_client, job)

    custom_bebr_log = [
        Record(
            dtype='bebr', event_type='bounds_change', path='nmaps_www.map', pid='458', puid='1',
            session_id='1', geo_id=213, region_id='213', puid_click=None, fielddate='2020-07-26',
            session_click=None, click=None, shows=None,
            vars={
                'newBounds': [[146.74376299728934, -19.291748663089077], [146.74575856079642, -19.29079361083855]],
                'newZoom': 20,
                'oldBounds': [[146.74394731678933, -19.291707537604058], [146.74594288029638, -19.29075248511075]],
                'oldZoom': 20
            }
        ),
        Record(
            dtype='bebr', event_type='click', path='nmaps_www.map', pid='458', puid='1',
            session_id='1', fielddate='2020-07-26', geo_id=213, region_id='213', puid_click='1',
            session_click='1', click=1, shows=None, vars={'button': 'left'}
        ),
        Record(
            dtype='bebr', event_type='show', path='nmaps_www.create_geoobject.header', pid='458', puid='2',
            session_id='2', fielddate='2020-07-26', geo_id=213, region_id='213', puid_click=None,
            session_click=None, click=None, shows=1, vars=None
        )
    ]

    nmaps_edits = [
        Record(puid='1', action_sum_create=1),
        Record(puid='2', action_sum_create=0)
    ]
    create_user_path = [
        Record(puid='2', user_path='\t_total_\t'),
        Record(puid='2', user_path='\t_total_\tyandex\t'),
        Record(puid='2', user_path='\t_total_\tyandex\tnew\t'),
        Record(puid='1', user_path='\t_total_\t'),
        Record(puid='1', user_path='\t_total_\tusers\t'),
        Record(puid='1', user_path='\t_total_\tusers\tmoderator\t')
    ]

    make_nmaps_edits_for_count = []

    job.local_run(
        sources={
            'custom_bebr_log': local.StreamSource(custom_bebr_log),
            'nmaps_edits': local.StreamSource(nmaps_edits),
            'create_user_path': local.StreamSource(create_user_path)
        },
        sinks={
            'make_nmaps_edits_for_count': local.ListSink(make_nmaps_edits_for_count)
        }
    )

    assert sorted(make_nmaps_edits_for_count) == sorted([
        Record(
            action_sum_create=0, click=None, event_path='\tnmaps_www\t', fielddate='2020-07-26',
            puid='2', puid_click=None, puid_created=None, region_id='213', session_click=None, session_id='2',
            shows=1, user_path='\t_total_\t'
        ),
        Record(
            action_sum_create=0, click=None, event_path='\tnmaps_www\t', fielddate='2020-07-26',
            puid='2', puid_click=None, puid_created=None, region_id='213', session_click=None, session_id='2',
            shows=1, user_path='\t_total_\tyandex\t'
        ),
        Record(
            action_sum_create=0, click=None, event_path='\tnmaps_www\t', fielddate='2020-07-26',
            puid='2', puid_click=None, puid_created=None, region_id='213', session_click=None, session_id='2',
            shows=1, user_path='\t_total_\tyandex\tnew\t'
        ),
        Record(
            action_sum_create=0, click=None, event_path='\tnmaps_www\tcreate_geoobject\t',
            fielddate='2020-07-26', puid='2', puid_click=None, puid_created=None, region_id='213',
            session_click=None, session_id='2', shows=1, user_path='\t_total_\t'
        ),
        Record(
            action_sum_create=0, click=None, event_path='\tnmaps_www\tcreate_geoobject\t',
            fielddate='2020-07-26', puid='2', puid_click=None, puid_created=None, region_id='213',
            session_click=None, session_id='2', shows=1, user_path='\t_total_\tyandex\t'
        ),
        Record(
            action_sum_create=0, click=None, event_path='\tnmaps_www\tcreate_geoobject\t',
            fielddate='2020-07-26', puid='2', puid_click=None, puid_created=None, region_id='213',
            session_click=None, session_id='2', shows=1, user_path='\t_total_\tyandex\tnew\t'
        ),
        Record(
            action_sum_create=0, click=None, event_path='\tnmaps_www\tcreate_geoobject\theader\t',
            fielddate='2020-07-26', puid='2', puid_click=None, puid_created=None, region_id='213',
            session_click=None, session_id='2', shows=1, user_path='\t_total_\t'
        ),
        Record(
            action_sum_create=0, click=None, event_path='\tnmaps_www\tcreate_geoobject\theader\t',
            fielddate='2020-07-26', puid='2', puid_click=None, puid_created=None, region_id='213',
            session_click=None, session_id='2', shows=1, user_path='\t_total_\tyandex\t'
        ),
        Record(
            action_sum_create=0, click=None, event_path='\tnmaps_www\tcreate_geoobject\theader\t',
            fielddate='2020-07-26', puid='2', puid_click=None, puid_created=None, region_id='213',
            session_click=None, session_id='2', shows=1, user_path='\t_total_\tyandex\tnew\t'
        ),
        Record(
            action_sum_create=1, click=None, event_path='\tnmaps_www\t', fielddate='2020-07-26',
            puid='1', puid_click=None, puid_created='1', region_id='213', session_click=None, session_id='1',
            shows=None, user_path='\t_total_\t'
        ),
        Record(
            action_sum_create=1, click=None, event_path='\tnmaps_www\t', fielddate='2020-07-26',
            puid='1', puid_click=None, puid_created='1', region_id='213', session_click=None, session_id='1',
            shows=None, user_path='\t_total_\tusers\t'
        ),
        Record(
            action_sum_create=1, click=None, event_path='\tnmaps_www\t', fielddate='2020-07-26',
            puid='1', puid_click=None, puid_created='1', region_id='213', session_click=None, session_id='1',
            shows=None, user_path='\t_total_\tusers\tmoderator\t'
        ),
        Record(
            action_sum_create=1, click=None, event_path='\tnmaps_www\tmap\t',
            fielddate='2020-07-26', puid='1', puid_click=None, puid_created='1', region_id='213',
            session_click=None, session_id='1', shows=None, user_path='\t_total_\t'
        ),
        Record(
            action_sum_create=1, click=None, event_path='\tnmaps_www\tmap\t',
            fielddate='2020-07-26', puid='1', puid_click=None, puid_created='1', region_id='213',
            session_click=None, session_id='1', shows=None, user_path='\t_total_\tusers\t'
        ),
        Record(
            action_sum_create=1, click=None, event_path='\tnmaps_www\tmap\t',
            fielddate='2020-07-26', puid='1', puid_click=None, puid_created='1', region_id='213',
            session_click=None, session_id='1', shows=None, user_path='\t_total_\tusers\tmoderator\t'
        ),
        Record(
            action_sum_create=1, click=None, event_path='\tnmaps_www\tmap\tbound_change\t',
            fielddate='2020-07-26', puid='1', puid_click=None, puid_created='1', region_id='213',
            session_click=None, session_id='1', shows=None, user_path='\t_total_\t'
        ),
        Record(
            action_sum_create=1, click=None, event_path='\tnmaps_www\tmap\tbound_change\t',
            fielddate='2020-07-26', puid='1', puid_click=None, puid_created='1', region_id='213',
            session_click=None, session_id='1', shows=None, user_path='\t_total_\tusers\t'
        ),
        Record(
            action_sum_create=1, click=None, event_path='\tnmaps_www\tmap\tbound_change\t',
            fielddate='2020-07-26', puid='1', puid_click=None, puid_created='1', region_id='213',
            session_click=None, session_id='1', shows=None, user_path='\t_total_\tusers\tmoderator\t'
        ),
        Record(
            action_sum_create=1, click=None, event_path='\tnmaps_www\tmap\tbound_change\tdrug\t',
            fielddate='2020-07-26', puid='1', puid_click=None, puid_created='1', region_id='213',
            session_click=None, session_id='1', shows=None, user_path='\t_total_\t'
        ),
        Record(
            action_sum_create=1, click=None, event_path='\tnmaps_www\tmap\tbound_change\tdrug\t',
            fielddate='2020-07-26', puid='1', puid_click=None, puid_created='1', region_id='213',
            session_click=None, session_id='1', shows=None, user_path='\t_total_\tusers\t'
        ),
        Record(
            action_sum_create=1, click=None, event_path='\tnmaps_www\tmap\tbound_change\tdrug\t',
            fielddate='2020-07-26', puid='1', puid_click=None, puid_created='1', region_id='213',
            session_click=None, session_id='1', shows=None, user_path='\t_total_\tusers\tmoderator\t'
        ),
        Record(
            action_sum_create=1, click=1, event_path='\tnmaps_www\t', fielddate='2020-07-26',
            puid='1', puid_click='1', puid_created='1', region_id='213', session_click='1', session_id='1',
            shows=None, user_path='\t_total_\t'
        ),
        Record(
            action_sum_create=1, click=1, event_path='\tnmaps_www\t', fielddate='2020-07-26',
            puid='1', puid_click='1', puid_created='1', region_id='213', session_click='1', session_id='1',
            shows=None, user_path='\t_total_\tusers\t'
        ),
        Record(
            action_sum_create=1, click=1, event_path='\tnmaps_www\t', fielddate='2020-07-26',
            puid='1', puid_click='1', puid_created='1', region_id='213', session_click='1', session_id='1',
            shows=None, user_path='\t_total_\tusers\tmoderator\t'
        ),
        Record(
            action_sum_create=1, click=1, event_path='\tnmaps_www\tmap\t',
            fielddate='2020-07-26', puid='1', puid_click='1', puid_created='1', region_id='213', session_click='1',
            session_id='1', shows=None, user_path='\t_total_\t'
        ),
        Record(
            action_sum_create=1, click=1, event_path='\tnmaps_www\tmap\t',
            fielddate='2020-07-26', puid='1', puid_click='1', puid_created='1', region_id='213', session_click='1',
            session_id='1', shows=None, user_path='\t_total_\tusers\t'
        ),
        Record(
            action_sum_create=1, click=1, event_path='\tnmaps_www\tmap\t',
            fielddate='2020-07-26', puid='1', puid_click='1', puid_created='1', region_id='213', session_click='1',
            session_id='1', shows=None, user_path='\t_total_\tusers\tmoderator\t'
        ),
        Record(
            action_sum_create=1, click=1, event_path='\tnmaps_www\tmap\tbutton\t',
            fielddate='2020-07-26', puid='1', puid_click='1', puid_created='1', region_id='213', session_click='1',
            session_id='1', shows=None, user_path='\t_total_\t'
        ),
        Record(
            action_sum_create=1, click=1, event_path='\tnmaps_www\tmap\tbutton\t',
            fielddate='2020-07-26', puid='1', puid_click='1', puid_created='1', region_id='213', session_click='1',
            session_id='1', shows=None, user_path='\t_total_\tusers\t'
        ),
        Record(
            action_sum_create=1, click=1, event_path='\tnmaps_www\tmap\tbutton\t',
            fielddate='2020-07-26', puid='1', puid_click='1', puid_created='1', region_id='213', session_click='1',
            session_id='1', shows=None, user_path='\t_total_\tusers\tmoderator\t'
        ),
        Record(
            action_sum_create=1, click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t',
            fielddate='2020-07-26', puid='1', puid_click='1', puid_created='1', region_id='213', session_click='1',
            session_id='1', shows=None, user_path='\t_total_\t'
        ),
        Record(
            action_sum_create=1, click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t',
            fielddate='2020-07-26', puid='1', puid_click='1', puid_created='1', region_id='213', session_click='1',
            session_id='1', shows=None, user_path='\t_total_\tusers\t'
        ),
        Record(
            action_sum_create=1, click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t',
            fielddate='2020-07-26', puid='1', puid_click='1', puid_created='1', region_id='213', session_click='1',
            session_id='1', shows=None, user_path='\t_total_\tusers\tmoderator\t'
        )
    ])


def test_prepare_result_counts(statface_client, job, major_regions):
    job = common.make_count_job(statface_client, job)

    add_region_tree = [
        Record(
            event_type='click', puid='1', fielddate='2020-07-26',
            user_path='\t_total_\t', session_id='1', region_id='213', puid_click='1', action_sum_create=1,
            session_click='1', click=1, shows=None, puid_created='1',
            event_path='\tnmaps_www\tmap\tbutton\tleft\t', region_tree='\t1000\t'
        ),
        Record(
            event_type='click', puid='1', fielddate='2020-07-26',
            user_path='\t_total_\tusers\t', session_id='1', puid_created='1',
            region_id='213', puid_click='1', action_sum_create=1, session_click='1', click=1, shows=None,
            event_path='\tnmaps_www\tmap\tbutton\tleft\t', region_tree='\t1000\t'
        ),
        Record(
            event_type='click', puid='1', fielddate='2020-07-26', puid_created='1',
            user_path='\t_total_\tusers\tmoderator\t', session_id='1',
            region_id='213', puid_click='1', action_sum_create=1, session_click='1', click=1, shows=None,
            event_path='\tnmaps_www\tmap\tbutton\tleft\t', region_tree='\t1000\t'
        ),
        Record(
            event_type='click', puid='1', fielddate='2020-07-26',
            user_path='\t_total_\t', session_id='1', puid_created='1',
            region_id='213', puid_click='1', action_sum_create=1, session_click='1', click=1, shows=None,
            event_path='\tnmaps_www\tmap\tbutton\tleft\t', region_tree='\t1000\t225\t'
        ),
        Record(
            event_type='click', puid='1', fielddate='2020-07-26',
            user_path='\t_total_\tusers\t', session_id='1', puid_created='1',
            region_id='213', puid_click='1', action_sum_create=1, session_click='1', click=1, shows=None,
            event_path='\tnmaps_www\tmap\tbutton\tleft\t', region_tree='\t1000\t225\t'
        ),
        Record(
            event_type='click', puid='1', fielddate='2020-07-26', puid_created='1',
            user_path='\t_total_\tusers\tmoderator\t', session_id='1',
            region_id='213', puid_click='1', action_sum_create=1, session_click='1', click=1, shows=None,
            event_path='\tnmaps_www\tmap\tbutton\tleft\t', region_tree='\t1000\t225\t'
        ),
        Record(
            event_type='show', puid='2', fielddate='2020-07-26', puid_created=None,
            user_path='\t_total_\t', session_id='2',
            region_id='213', puid_click=None, action_sum_create=0, session_click=None, click=None, shows=1,
            event_path='\tnmaps_www\tcreate_geoobject\theader\t', region_tree='\t1000\t225\t'
        ),
        Record(
            event_type='show', puid='2', fielddate='2020-07-26', puid_created=None,
            user_path='\t_total_\tyandex\t', session_id='2',
            region_id='213', puid_click=None, action_sum_create=0, session_click=None, click=None, shows=1,
            event_path='\tnmaps_www\tcreate_geoobject\theader\t', region_tree='\t1000\t225\t'
        ),
        Record(
            event_type='show', puid='2', fielddate='2020-07-26', puid_created=None,
            user_path='\t_total_\tyandex\tnew\t', session_id='2',
            region_id='213', puid_click=None, action_sum_create=0, session_click=None, click=None, shows=1,
            event_path='\tnmaps_www\tcreate_geoobject\theader\t', region_tree='\t1000\t225\t'
        )
    ]

    prepare_result_counts = []
    aggregate_by_puid_click = []
    aggregate_by_puid_edits = []
    aggregate_by_puid_created = []
    aggregate_by_session_id = []
    aggregate_by_session_click = []
    aggregate_bu_sum_click = []
    aggregate_bu_sum_show = []
    aggregate_by_puid = []

    job.local_run(
        sources={
            'add_region_tree': local.StreamSource(add_region_tree),
            'major_regions': local.StreamSource(major_regions)
        },
        sinks={
            'aggregate_by_puid': local.ListSink(aggregate_by_puid),
            'aggregate_by_puid_click': local.ListSink(aggregate_by_puid_click),
            'aggregate_by_puid_edits': local.ListSink(aggregate_by_puid_edits),
            'aggregate_by_puid_created': local.ListSink(aggregate_by_puid_created),
            'aggregate_by_session_id': local.ListSink(aggregate_by_session_id),
            'aggregate_by_session_click': local.ListSink(aggregate_by_session_click),
            'aggregate_bu_sum_click': local.ListSink(aggregate_bu_sum_click),
            'aggregate_bu_sum_show': local.ListSink(aggregate_bu_sum_show),
            'prepare_result_counts': local.ListSink(prepare_result_counts)
        }
    )

    assert sorted(aggregate_by_puid) == sorted([
        Record(count_uniq_puid=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\t'),
        Record(count_uniq_puid=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tyandex\t'),
        Record(count_uniq_puid=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tyandex\tnew\t'),
        Record(count_uniq_puid=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\t'),
        Record(count_uniq_puid=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\tusers\t'),
        Record(count_uniq_puid=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\tusers\tmoderator\t'),
        Record(count_uniq_puid=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\t'),
        Record(count_uniq_puid=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tusers\t'),
        Record(count_uniq_puid=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tusers\tmoderator\t')
    ])

    assert sorted(aggregate_by_puid_click) == sorted([
        Record(count_uniq_puid_click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\t'),
        Record(count_uniq_puid_click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\tusers\t'),
        Record(count_uniq_puid_click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\tusers\tmoderator\t'),
        Record(count_uniq_puid_click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\t'),
        Record(count_uniq_puid_click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tusers\t'),
        Record(count_uniq_puid_click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tusers\tmoderator\t')
    ])

    assert sorted(aggregate_by_puid_edits) == sorted([
        Record(count_uniq_puid_edits=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\t'),
        Record(count_uniq_puid_edits=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tyandex\t'),
        Record(count_uniq_puid_edits=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tyandex\tnew\t'),
        Record(count_uniq_puid_edits=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\t'),
        Record(count_uniq_puid_edits=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\tusers\t'),
        Record(count_uniq_puid_edits=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\tusers\tmoderator\t'),
        Record(count_uniq_puid_edits=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\t'),
        Record(count_uniq_puid_edits=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tusers\t'),
        Record(count_uniq_puid_edits=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tusers\tmoderator\t')
    ])

    assert sorted(aggregate_by_puid_created) == sorted([
        Record(count_uniq_puid_created=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\t'),
        Record(count_uniq_puid_created=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tyandex\t'),
        Record(count_uniq_puid_created=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tyandex\tnew\t'),
        Record(count_uniq_puid_created=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\t'),
        Record(count_uniq_puid_created=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\tusers\t'),
        Record(count_uniq_puid_created=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\tusers\tmoderator\t'),
        Record(count_uniq_puid_created=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\t'),
        Record(count_uniq_puid_created=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tusers\t'),
        Record(count_uniq_puid_created=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tusers\tmoderator\t')
    ])

    assert sorted(aggregate_by_session_id) == sorted([
        Record(count_uniq_session_id=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\t'),
        Record(count_uniq_session_id=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tyandex\t'),
        Record(count_uniq_session_id=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tyandex\tnew\t'),
        Record(count_uniq_session_id=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\t'),
        Record(count_uniq_session_id=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\tusers\t'),
        Record(count_uniq_session_id=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\tusers\tmoderator\t'),
        Record(count_uniq_session_id=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\t'),
        Record(count_uniq_session_id=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tusers\t'),
        Record(count_uniq_session_id=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tusers\tmoderator\t')
    ])

    assert sorted(aggregate_by_session_click) == sorted([
        Record(count_uniq_session_click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\t'),
        Record(count_uniq_session_click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\tusers\t'),
        Record(count_uniq_session_click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t', user_path='\t_total_\tusers\tmoderator\t'),
        Record(count_uniq_session_click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\t'),
        Record(count_uniq_session_click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tusers\t'),
        Record(count_uniq_session_click=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tusers\tmoderator\t')
    ])

    assert sorted(aggregate_bu_sum_click) == sorted([
        Record(event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26', region_tree='\t1000\t',
               sum_click=1, user_path='\t_total_\t'),
        Record(event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26', region_tree='\t1000\t',
               sum_click=1, user_path='\t_total_\tusers\t'),
        Record(event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26', region_tree='\t1000\t',
               sum_click=1, user_path='\t_total_\tusers\tmoderator\t'),
        Record(event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26', region_tree='\t1000\t225\t',
               sum_click=1, user_path='\t_total_\t'),
        Record(event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26', region_tree='\t1000\t225\t',
               sum_click=1, user_path='\t_total_\tusers\t'),
        Record(event_path='\tnmaps_www\tmap\tbutton\tleft\t', fielddate='2020-07-26', region_tree='\t1000\t225\t',
               sum_click=1, user_path='\t_total_\tusers\tmoderator\t')
    ])

    assert sorted(aggregate_bu_sum_show) == sorted([
        Record(sum_show=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\t'),
        Record(sum_show=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tyandex\t'),
        Record(sum_show=1, event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26',
               region_tree='\t1000\t225\t', user_path='\t_total_\tyandex\tnew\t'),
    ])

    assert sorted(prepare_result_counts) == sorted([
        Record(count_uniq_puid=1, count_uniq_puid_click=0, count_uniq_puid_created=1, count_uniq_puid_edits=1,
               count_uniq_session_click=0, count_uniq_session_id=1,
               event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26', geo_path='\t1000\t225\t',
               sum_click=0, sum_show=1, user_path='\t_total_\t'),
        Record(count_uniq_puid=1, count_uniq_puid_click=0, count_uniq_puid_created=1, count_uniq_puid_edits=1,
               count_uniq_session_click=0, count_uniq_session_id=1,
               event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26', geo_path='\t1000\t225\t',
               sum_click=0, sum_show=1, user_path='\t_total_\tyandex\t'),
        Record(count_uniq_puid=1, count_uniq_puid_click=0, count_uniq_puid_created=1, count_uniq_puid_edits=1,
               count_uniq_session_click=0, count_uniq_session_id=1,
               event_path='\tnmaps_www\tcreate_geoobject\theader\t', fielddate='2020-07-26', geo_path='\t1000\t225\t',
               sum_click=0, sum_show=1, user_path='\t_total_\tyandex\tnew\t'),
        Record(count_uniq_puid=1, count_uniq_puid_click=1, count_uniq_puid_created=1, count_uniq_puid_edits=1,
               count_uniq_session_click=1, count_uniq_session_id=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t',
               fielddate='2020-07-26', geo_path='\t1000\t', sum_click=1, sum_show=0, user_path='\t_total_\t'),
        Record(count_uniq_puid=1, count_uniq_puid_click=1, count_uniq_puid_created=1, count_uniq_puid_edits=1,
               count_uniq_session_click=1, count_uniq_session_id=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t',
               fielddate='2020-07-26', geo_path='\t1000\t', sum_click=1, sum_show=0, user_path='\t_total_\tusers\t'),
        Record(count_uniq_puid=1, count_uniq_puid_click=1, count_uniq_puid_created=1, count_uniq_puid_edits=1,
               count_uniq_session_click=1, count_uniq_session_id=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t',
               fielddate='2020-07-26', geo_path='\t1000\t', sum_click=1, sum_show=0,
               user_path='\t_total_\tusers\tmoderator\t'),
        Record(count_uniq_puid=1, count_uniq_puid_click=1, count_uniq_puid_created=1, count_uniq_puid_edits=1,
               count_uniq_session_click=1, count_uniq_session_id=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t',
               fielddate='2020-07-26', geo_path='\t1000\t225\t', sum_click=1, sum_show=0, user_path='\t_total_\t'),
        Record(count_uniq_puid=1, count_uniq_puid_click=1, count_uniq_puid_created=1, count_uniq_puid_edits=1,
               count_uniq_session_click=1, count_uniq_session_id=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t',
               fielddate='2020-07-26', geo_path='\t1000\t225\t', sum_click=1, sum_show=0,
               user_path='\t_total_\tusers\t'),
        Record(count_uniq_puid=1, count_uniq_puid_click=1, count_uniq_puid_created=1, count_uniq_puid_edits=1,
               count_uniq_session_click=1, count_uniq_session_id=1, event_path='\tnmaps_www\tmap\tbutton\tleft\t',
               fielddate='2020-07-26', geo_path='\t1000\t225\t', sum_click=1, sum_show=0,
               user_path='\t_total_\tusers\tmoderator\t')
    ])
