import argparse

from nile.api.v1 import (
    clusters,
    statface as ns
)

from maps.wikimap.stat.nmaps_feedback.lib.eval_report import make_job

NMAPS_FEEDBACK_REPORT_PATH = 'Maps.Wiki/Others/NmapsFeedback'
TMP_PATH = '//home/maps/core/nmaps/robot-wikimap/tmp/nile'


def main():
    parser = argparse.ArgumentParser(
        description="Use environment variables 'YT_TOKEN', 'STATFACE_TOKEN' for OAuth authorization."
    )
    parser.add_argument(
        '--from-date',
        help="The first date of the range, iso format: 2018-12-31",
        required=True
    )
    parser.add_argument(
        '--to-date',
        help='The last day of the range, iso format: 2018-12-31. Equals to --from-date by default',
        required=False
    )
    parser.add_argument(
        '--statface-prod',
        help='Upload to Statface production instead of beta. (default: False)',
        action='store_true'
    )
    parser.add_argument(
        '--report',
        help='Path to report in stat (default: %s)' % NMAPS_FEEDBACK_REPORT_PATH,
        default=NMAPS_FEEDBACK_REPORT_PATH
    )
    parser.add_argument(
        '--dump-date',
        help='YT user-dump-tables date suffix, iso format: 2018-12-31',
        required=True
    )
    args = parser.parse_args()

    cluster = clusters.yt.Hahn()

    if args.statface_prod:
        statface_client = ns.StatfaceProductionClient()
    else:
        statface_client = ns.StatfaceBetaClient()

    from_date = args.from_date
    to_date = args.to_date if args.to_date else from_date

    job = cluster.env(
        parallel_operations_limit=8,
        templates=dict(
            tmp_root=TMP_PATH,
        ),
    ).job("make-feedback-stat")
    make_job(
        job, from_date, to_date, args.report,
        statface_client, args.dump_date)
    job.run()


if __name__ == '__main__':
    main()
