import maps.wikimap.stat.nmaps_feedback.lib.eval_report as eval_report

from nile.api.v1 import cli

import datetime


@cli.statinfra_job(options=[cli.Option('report', required=True)])
def make_nirvana_job(job, nirvana, options, statface_client):
    yesterday = datetime.date.today() - datetime.timedelta(days=1)
    return eval_report.make_job(
        job, yesterday.isoformat(), yesterday.isoformat(), options.report,
        statface_client, yesterday.isoformat())


def main():
    cli.run()


if __name__ == "__main__":
    main()
