import nile.api.v1.datetime as nd

MEMORY_LIMIT = 512

COMMON_GROUP_FIELDS = ('window_days', 'fielddate', 'geo_path', 'source_path', 'type_path', 'test_id_path')
REPORT_DIMENSIONS = COMMON_GROUP_FIELDS + ('user_resolved_path',)


class DateWindowsConfig:
    def __init__(self, from_date, to_date, windows_days, dump_date):
        self.from_date = from_date
        self.to_date = to_date
        self.windows_days = windows_days
        self.dump_date = dump_date

        self.left_margin = nd.Datetime.from_iso(from_date).next(offset=-max(windows_days)+1)
        self.right_margin = nd.Datetime.from_iso(to_date).next()

    def windows(self):
        fielddates = list(nd.datetime_range(self.from_date, self.to_date))

        for fielddate in fielddates:
            for window_days in self.windows_days:
                yield (
                    fielddate,
                    window_days,
                    nd.Datetime.from_iso(fielddate).next(offset=-window_days + 1),
                    nd.Datetime.from_iso(fielddate).next()
                )


def action_before_datetime(action_at, datetime):
    return action_at is not None and nd.Datetime.from_iso(action_at) < datetime


def action_in_window_datetime(action_at, window_start, window_end):
    return action_at is not None and window_start <= nd.Datetime.from_iso(action_at) < window_end


def extract_some_user_id(original_task):
    if original_task is None:
        return None
    metadata = original_task.get('metadata')
    if metadata is None:
        return None

    uid = metadata.get('uid')
    yandexuid = metadata.get('yandexuid')
    device_id = metadata.get('device_id')

    return uid or yandexuid or device_id


def cut_to_seconds(date_iso_str):
    """
    "2018-08-01 00:00:00.000000+03"
                        ^^^^^^^^^^
                        unwanted part
    """
    return date_iso_str[:19]


def list_to_tree_str(lst):
    return '\t%s\t' % '\t'.join(map(str, lst))


def path_with_total(name):
    return ['_total_', str(name)]


def sanitize_tree_part(part):
    if part is None:
        return '_no_key_'
    elif part == '':
        return '_empty_'
    else:
        return part


def subsource_path_list(source_branch, original_task):
    result = [source_branch]

    if original_task is not None:
        metadata = original_task.get('metadata', {})

        result.append(metadata.get('client_id'))
        result.append(original_task.get('form_id'))
        result.append(original_task.get('form_type'))
        result.append(original_task.get('form_context_id'))

        app_version = metadata.get('application_version')
        if app_version is not None:
            result.append(app_version)

    return [sanitize_tree_part(part) for part in result]
