from nile.api.v1 import (
    extractors as ne
)
from qb2.api.v1 import (
    extractors as qe,
)

from .common import MEMORY_LIMIT, list_to_tree_str, path_with_total


def unfold_region_tree(feedback_table, regions_table):
    regions_map = regions_table.project('region_id', 'population', geo_path='region_tree')

    return feedback_table.join(
        regions_map,
        by='region_id',

        memory_limit=MEMORY_LIMIT,
    )


def source_path_list(source, subsource_path):
    ret_val = path_with_total(source)
    if subsource_path is not None:
        ret_val += subsource_path

    return [val.encode('utf-8') for val in ret_val]


def unfold_common_dimensions(feedback_table, regions_table):
    return feedback_table.call(
        unfold_region_tree, regions_table=regions_table
    ).project(
        ne.all(),
        qe.custom('source_path_list', source_path_list, 'source', 'subsource_path')
            .allow_null_dependency().hide(),
        qe.custom('type_path_list', path_with_total, 'type').hide(),
        qe.unfold_prefixes('source_path_prefix', 'source_path_list').hide(),
        qe.unfold_prefixes('type_path_prefix', 'type_path_list').hide(),
        source_path=ne.custom(list_to_tree_str, 'source_path_prefix'),
        type_path=ne.custom(list_to_tree_str, 'type_path_prefix'),
        test_id_path=ne.const('\t_total_\t'),  # legacy: NMAPS-15434

        memory_limit=MEMORY_LIMIT,
    )
