from maps.wikimap.stat.nmaps_feedback.lib.common import subsource_path_list

NO_KEY = '_no_key_'
EMPTY = '_empty_'


def test_subsource_path_list():
    source_root = 'sprav'

    assert [source_root] == subsource_path_list(source_root, None)

    original_task_empty = {}
    assert [source_root, NO_KEY, NO_KEY, NO_KEY, NO_KEY] == \
        subsource_path_list(source_root, original_task_empty)

    original_task_empty_meta = {'metadata': {}}
    assert [source_root, NO_KEY, NO_KEY, NO_KEY, NO_KEY] == \
        subsource_path_list(source_root, original_task_empty_meta)

    original_task_app_version_none = {'metadata': {'application_version': None}}
    assert [source_root, NO_KEY, NO_KEY, NO_KEY, NO_KEY] == \
        subsource_path_list(source_root, original_task_app_version_none)

    original_task_app_version = {'metadata': {'application_version': '1.0'}}
    assert [source_root, NO_KEY, NO_KEY, NO_KEY, NO_KEY, '1.0'] == \
        subsource_path_list(source_root, original_task_app_version)

    original_task_client_id = {'metadata': {'client_id': 'ru.yandex.yandexmaps'}}
    assert [source_root, 'ru.yandex.yandexmaps', NO_KEY, NO_KEY, NO_KEY] == \
        subsource_path_list(source_root, original_task_client_id)

    original_task_full = {
        'metadata': {'client_id': 'ru.yandex.yandexmaps'},
        'form_id': 'organization',
        'form_type': 'organization/edit-info',
        'form_context_id': 'organization.footer'
    }
    assert [
        source_root,
        'ru.yandex.yandexmaps',
        'organization',
        'organization/edit-info',
        'organization.footer'
    ] == subsource_path_list(source_root, original_task_full)

    original_task_full_app_version = {
        'metadata': {
            'client_id': 'ru.yandex.yandexmaps',
            'application_version': '1.0'
        },
        'form_id': 'organization',
        'form_type': 'organization/edit-info',
        'form_context_id': 'organization.footer'
    }
    assert [
        source_root,
        'ru.yandex.yandexmaps',
        'organization',
        'organization/edit-info',
        'organization.footer',
        '1.0'
    ] == subsource_path_list(source_root, original_task_full_app_version)

    original_task_empty_strs = {
        'metadata': {
            'client_id': '',
            'application_version': ''
        },
        'form_id': '',
        'form_type': '',
        'form_context_id': ''
    }
    assert [
        source_root,
        EMPTY,
        EMPTY,
        EMPTY,
        EMPTY,
        EMPTY
    ] == subsource_path_list(source_root, original_task_empty_strs)
