import argparse
import collections

from nile.api.v1 import (
    clusters,
    statface as ns
)

import eval_report


def main():

    parser = argparse.ArgumentParser()

    parser.add_argument("--task-type", type=str, help="Task type", default='address')
    parser.add_argument("--tasks", type=str, help="Path to tasks table", required=True)
    parser.add_argument("--export", type=str, help="Path to export table", required=True)
    parser.add_argument("--report", type=str, help="Path to report in stat", required=True)
    parser.add_argument("--statface-token", type=str, help="Statface token", required=True)
    parser.add_argument("--yt-token", type=str, help="Yt token")

    args = parser.parse_args()

    if args.yt_token:
        cluster = clusters.yt.Hahn(args.yt_token)
    else:
        cluster = clusters.yt.Hahn()
    statface_client = ns.StatfaceBetaClient(
        token=args.statface_token
    )

    job = cluster.job()

    nirvana = collections.namedtuple("Nirvana", "input_tables")(
        [args.tasks, args.export]
    )
    options = collections.namedtuple("Options", "report task_type")(
        args.report,
        args.task_type
    )

    job = eval_report.make_job(job, nirvana, options, statface_client)

    job.run()


if __name__ == "__main__":
    main()
