import eval_report

from nile.api.v1 import (
    datetime as nd,
    local,
    clusters,
    Record
)

import time


def datetime_to_ts(dt):
    return int(time.mktime(dt.timetuple()))


def datetime_to_ms(dt):
    return datetime_to_ts(dt) * 1000


def test_local_example():
    cluster = clusters.MockCluster()
    job = cluster.job()
    job = eval_report.make_testable_job(
        job,
        "address",
        nd.Datetime(2019, 1, 10),
        nd.Datetime(2019, 2, 10)
    )

    tasks = [
        Record(timestamp=datetime_to_ts(nd.Datetime(2019, 1, 10, 12, 0)), buildingId='building-id=1', taskId='task-id=1'),
        Record(timestamp=datetime_to_ts(nd.Datetime(2019, 1, 10, 12, 0)), buildingId='building-id=2', taskId='task-id=1'),
        Record(timestamp=datetime_to_ts(nd.Datetime(2019, 1, 10, 12, 0)), buildingId='building-id=3', taskId='task-id=1'),
        Record(timestamp=datetime_to_ts(nd.Datetime(2019, 1, 10, 12, 0)), buildingId='building-id=4', taskId='task-id=1'),
    ]

    exports = [
        Record(createdAt=datetime_to_ms(nd.Datetime(2019, 2, 10, 12, 0)), nmapsBuildingId='building-id=1', nmapsTaskId='task-id=1', state='address'),
        Record(createdAt=datetime_to_ms(nd.Datetime(2019, 2, 10, 12, 1)), nmapsBuildingId='building-id=2', nmapsTaskId='task-id=1', state='no-address'),
        Record(createdAt=datetime_to_ms(nd.Datetime(2019, 2, 10, 12, 2)), nmapsBuildingId='building-id=3', nmapsTaskId='task-id=1', state='never-done'),
        Record(createdAt=datetime_to_ms(nd.Datetime(2019, 2, 10, 12, 3)), nmapsBuildingId='building-id=3', nmapsTaskId='task-id=1', state='never-done'),
    ]

    daily_result = []
    weekly_result = []
    monthly_result = []

    job.local_run(
        sources={
            "tasks": local.StreamSource(tasks),
            "export": local.StreamSource(exports),
        },
        sinks={
            "daily_result": local.ListSink(daily_result),
            "weekly_result": local.ListSink(weekly_result),
            "monthly_result": local.ListSink(monthly_result),
        }
    )

    is_record_trivial = lambda r: r.to_dict().keys() == ['fielddate', 'in_progress'] and r['in_progress'] == 4

    assert len(daily_result) == 32
    significant_daily_records = filter(
        lambda r: not is_record_trivial(r),
        daily_result)
    assert significant_daily_records == [
        Record(fielddate='2019-01-10', in_progress=4, sent=4),
        Record(fielddate='2019-02-10', exported=3, exported_fail=1, exported_never_done=1, exported_success=1, in_progress=1),
    ]

    assert len(weekly_result) == 5
    significant_weekly_records = filter(
        lambda r: not is_record_trivial(r),
        weekly_result)
    assert significant_weekly_records == [
        Record(fielddate='2019-01-07', in_progress=4, sent=4),
        Record(fielddate='2019-02-04', exported=3, exported_fail=1, exported_never_done=1, exported_success=1, in_progress=1),
    ]

    assert monthly_result == [
        Record(fielddate='2019-01-01', in_progress=4, sent=4),
        Record(fielddate='2019-02-01', exported=3, exported_fail=1, exported_never_done=1, exported_success=1, in_progress=1),
    ]
