from maps.wikimap.stat.tasks_payment.dictionaries.libs import oebs_api

import datetime


HOLIDAYS_SCHEMA = [
    {"name": "staff_login", "type": "string", "required": True},
    {"name": "date", "type": "string", "required": True},
]


def _make_record(login, date):
    return {
        'staff_login': login,
        'date': date
    }


def _get_records(holidays, date):
    result = []
    for user_data in holidays:
        if date in user_data['holiday']:
            result.append(_make_record(user_data['login'], date))
    return result


def get_holidays(env, oebs_api_client_id, oebs_api_tvm_secret, logins, date):
    holidays = oebs_api.holiday(
        env,
        oebs_api_client_id,
        oebs_api_tvm_secret,
        logins,
        date - datetime.timedelta(days=1),  # Workaround for OEBSSUPPORT-58635
        date
    )

    assert 'logins' in holidays, 'Cannot retrieve information about holidays from OEBS.'
    return _get_records(holidays['logins'], date.isoformat())
