from nile.api.v1 import cli
from yt.wrapper import ypath_join
from maps.wikimap.stat.tasks_payment.dictionaries.linked_accounts.lib import linked_accounts
import maps.wikimap.stat.libs.common.lib.cli_options as cli_opts


def eval_results_default(options):
    return ypath_join(options.analytics, linked_accounts.RESULT_PATH)


def make_link(driver, options):
    driver.client.link(
        ypath_join(cli_opts.get_results_path(options, eval_results_default), cli_opts.get_single_date(options)),
        ypath_join(cli_opts.get_results_path(options, eval_results_default), 'latest'),
        force=True
    )


@cli.statinfra_job(
    options=[
        cli_opts.analytics_option(),
        cli_opts.logs_option(),
        cli_opts.results_option(eval_results_default, 'analytics')
    ],
    final_action=make_link
)
def make_job(job, options):
    return linked_accounts.make_job(
        job,
        cli_opts.get_single_date(options),
        logs_path=options.logs,
        analytics_path=options.analytics,
        results_path=ypath_join(cli_opts.get_results_path(options, eval_results_default), cli_opts.get_single_date(options))
    )


def main():
    cli.run()
