from maps.wikimap.stat.tasks_payment.dictionaries.puid_map.lib.puid_map import (
    prepare_puid_map_and_info,
    cast_puid,
)
from nile.api.v1 import cli
from yt.wrapper import ypath_join
from qb2.api.v1 import typing as qtyping


@cli.statinfra_job
def make_job(job, options):
    for date in options.dates:
        puid_map, puid_info = prepare_puid_map_and_info(
            job,
            users_dump=job.table(ypath_join('//logs/nmaps-users-dump-log/1d', date)),
            outsourcers_dump=job.table(ypath_join('//logs/nmaps-outsourcers-dump-log/1d', date)),
            acl_roles_dump=cast_puid(job.table(ypath_join('//home/logfeller/logs/nmaps-acl-roles-dump/1d/', date))),
            staff_dump=job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/staff_dump', date))
        )

        puid_map.put(
            ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/puid_map', date),
            schema={
                'puid': qtyping.UInt64,
                'puid_tree': qtyping.String,
            },
            ensure_optional=False,
        )

        puid_info.put(
            ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/puid_info', date),
            schema={
                'puid': qtyping.Int64,
                'payment': qtyping.String,
                'involvement': qtyping.String,
                'group': qtyping.String,
                'person': qtyping.String,
            },
            ensure_optional=False,
        )

    return job


def main():
    cli.run()
