Описание всех поштучных/позонных задач сделки и аутсорса
========================================================
Для расчета стоимости работ используется настоящее формализованное описание всех работ и тарифов.
Для представления в отчете используется дерево работ в виде

    all / task_group / task_subgroup / tariff_name / task_name

или

    all / task_group / tariff_name / task_name

Пример: `all / Фидбек / Пользовательский / Адреса и подъезды / fbapi/entrance`.

Агрегация "штук" и нормосекунд в отчете производится по всем уровням дерева работ (хотя на верхних уровнях штуки и становятся довольно бессмысленными).

Группа работ `task_group` описывает работы на верхнем уровне:
Группа         | Вид работ
---------------|-------------------------------------
Фидбек         | разбор фидбека
Трекер         | задачи из очередей MAPSPW, OUTKARTPW и FEEDBACKPW
Модерация      | модерация
Зоны аутсорса  | работа по зонам аутсорса

В некоторых группах вид работ дополнительно уточняются подгруппами, например, для фидбека это:
Подгруппа        | Вид работ
-----------------|------------------------
Гипотезы         | гипотезы
Пользовательский | фидбек от пользователей
Валидации        | ошибки валидаций


Формат описания
---------------
Для удобства описание работ и тарифов разбиты на отдельные файлы по группам работ (фидбек, гипотезы, яндекс-модерация и прочие).


### Описание группы работ
В начале файла задается описание группы работ:
* `task_group` - группа работ, верхний уровень в дереве работ (после 'all'), например `outsource`, `moderation`.
* `task_subgroup` - подгруппа работ, опционально. Например `yandex` и `cartographer` для группы `moderation`.
* `task_prefix` - общий префикс для всех id задач в этой группе работ. Например, `moderation/closed` для картографической модерации.
* `task_prefixes` - аналогично `task_prefix`, но содержит список префиксов, что позволяет не дублировать тарифы с разными префиксами, но с одинаковыми идентификаторами задач `tasks` (смотри в разделе **Описание тарифов**). Пример: `[feedback/accept/, feedback/need-info/]`.

Описание группы работ должно содержать `task_prefix` или `task_prefixes`, но не может содержать их одновременно.


### Описание тарифов
В списке `tariffs` перечисляются тарифы. Каждый тариф задаётся следующим набором полей:
* `tariff_name` - имя тарифа в дереве работ. Не должно быть одинакового имени у двух тарифов в одной группе/подгруппе работ. Тарифы с одинаковой ценой нужно объединить в один тариф, для тарифов с разной ценой нужно эту разницу отобразить в названии (например, в виде коэфициента - `address` и `address/2.0`).
* `seconds` - цена за единицу работы в секундах. Дробная часть отделяется точкой.
* `rub` - цена за единицу работы в рублях. Дробная часть отделяется точкой. Это справочное поле, в расчете не используется. В тестах проверяется корректность соотношения рублей и секунд.
* `tasks` - список задач, выполняемых по этому тарифу, смотри описание ниже.
* `start_date` - первый день применения тарифа, опциональное поле, по умолчанию - "начало времен".
* `end_date` - последний день применения тарифа, опциональное поле, по умолчанию - "конец времен". Подробное описание смотри ниже в разделе **Изменение тарифа**.

Задачи в списке `tasks` задаются своим идентификатором.
После добавления префикса `task_prefix` идентификатор должен соответствовать идентификатору задачи в [логе работ][tasks_logs].
Без добавления префикса id используется для отображения в дереве работ.
Должно быть уникальным в рамках одного тарифа.
В разных тарифах задачи могут быть одинаковыми, только если эти тарифы не пересекаются по времени действия.
В группах(подгруппах) задач с различными `task_prefix` идентификаторы задач могут быть одинаковыми.
Так, задачи модерации адресов первого уровня и второго уровня могут иметь одно имя.

При построении отчета берутся все выполненные задачи из соответствующих логов (модерации, фидбека и др.) и по описанным выше тарифам определяется цена за задачу.

Описание требуется и для работ модерации/разбора фидбека, которые сдельщики выполняют в почасовом/посуточном режиме оплаты, либо которые сделка не выполняет вовсе (только сотрудники, или только народные модераторы). Для таких работ нужно указать нулевой поштучный тариф.


Добавление новых задач и другие изменения тарификации
-----------------------------------------------------

### Новая задача в уже существуюй тарифной группе
* Добавить идентификатор новой задачи в соответствующий файл, в раздел `tasks` нужного существующего тарифа.


### Новая задача с новым поштучным тарифом
* Добавить новый тариф в файл, соответствующий категории задач, указать цену в секундах и рублях.
* Добавить новую задачу в раздел `tasks` нового тарифа.


### Новая задача с почасовым тарифом
Это могут быть разовые эксперименты непонятной сложности, или первый разбор заданий для установки тарифа.
* Добавить задачу со специальным нулевым тарифом, чтобы поштучная стоимость работ была нулевой, например в тариф `paid-per-time`.
  Смотри выше.


### Новая категория в редакторе и, соответственно, новая категория модерации
* Если новая категория модерируется только штатными картографами, нужно завести работы модерации 1 и 2 уровня с нулевым тарифом `staff-only`.
* Если новая категория модерируется с оплатой за дежурства или часы, нужно завести работу(ы) с нулевым тарифом `paid-per-time`.
* Если новая категория проходит и яндекс-модерацию, и картографическую, нужно создать обе соответствующие задачи.
* Если задача проходит только один тип модерации, то для другого типа нужно создать задачу с тарифом с нулевой ценой `cartographer-only` / `yandex-only`.
* Для задач, модерируемых специальными аутсорсерами по особым правилам, для которых поштучный расчет не используется, можно использовать нулевой тариф `0-other`.


### Изменение цены существующего тарифа
Изменения в тарифах нужно делать заранее:
* Необходимо создать новый тариф, скопировав из старого все задачи.
* Указать у нового тарифа новое имя (например, добавив к старому имени порядковый номер или год).
* Указать у нового тарифа новую цену.
* Указать у нового тарифа дату начала действия `start_date`.
* Указать у старого тарифа дату окончания действия `end_date`.
С момента start_date работы по тарифу получат новое имя и новую цену.


### Изменение имени существующего тарифа
Название тарифа применяется к данным в момент рассчета логов, не в момент отображения. Поэтому, если изменить названии тарифа без закрытия и создания нового, в каком-то периоде часть работ будет обозначена тарифом со старым названием, часть - с новым.
Поэтому необходимо действовать аналогично предыдущему случаю:
* Создать новый тариф, скопировав из старого все задачи и цену.
* Указать у нового тарифа правильное имя.
* Указать у нового тарифа дату начала действия `start_date`.
* Указать у старого тарифа дату окончания действия `end_date`.
С момента start_date работы по тарифу получат новое имя.


### Изменения тарифа у задачи, создание для этой задачи нового тарифа
Для того, чтобы у одной из задач в тарифе А сменить тариф на новый Б, с даты 2020-05-16 нужно закрыть изменяемый тариф и создать два новых, с правильной привязкой перемещаемой задачи:
* Создать новый тариф A', скопировав из старого A все задачи, кроме переносимой, и цену. Указать новое имя тарифа.
* Создать новый тариф Б, приписав к нему переносимую задачу.
* Указать у нового тарифа А' дату начала действия `start_date: 2020-05-16`.
* Указать у старого тарифа А дату окончания действия `end_date: 2020-05-15`.
* Указать у нового тарифа Б дату начала действия `start_date: 2020-05-16`.


### Изменения тарифа у задачи, перенос задачи из одного тарифа в другой
Для того, чтобы у одной из задач в тарифе А сменить тариф на другой существующий Б начиная с 2020-05-16, нужно:
* Создать новый тариф A', скопировав из старого А все задачи, кроме переносимой, и цену. Указать новое имя.
* Создать новый тариф Б', скопировав из старого Б все задачи плюс переносимая и цену. Указать новое имя.
* Указать у нового тарифа А' дату начала действия `start_date: 2020-05-16`.
* Указать у нового тарифа Б' дату начала действия `start_date: 2020-05-16`.
* Указать у старого тарифа А дату окончания действия `end_date: 2020-05-15`.
* Указать у старого тарифа Б дату окончания действия `end_date: 2020-05-15`.


[tasks_logs]: https://yt.yandex-team.ru/hahn/navigation?path=//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs
