from maps.wikimap.stat.tasks_payment.dictionaries.libs import oebs_api

import sys


WORK_SCHEDULE_SCHEMA = [
    {"name": "staff_login", "type": "string", "required": True},
    {"name": "schedule", "type": "string", "required": True},
]

_SCHEDULE_STD = 'std'
_SCHEDULE_SHIFTED = 'shifted'
_SCHEDULE_UNKNOWN = 'unknown'


def _get_schedule_type(login, assignment):
    assert 'login' in assignment, f'No "login" field in assignment for "{login}".'
    assert assignment['login'] == login, f'Unexpected login "{assignment["login"]}" in assignment for "{login}".'

    if 'isNonStdSchedule' not in assignment:
        return _SCHEDULE_UNKNOWN

    is_non_std_schedule = assignment['isNonStdSchedule']['name']
    if is_non_std_schedule == 'Y':
        return _SCHEDULE_SHIFTED
    elif is_non_std_schedule == 'N':
        return _SCHEDULE_STD

    raise RuntimeError(f'Unsupported isNonStdSchedule value "{is_non_std_schedule}" for login "{login}"')


def _make_record(login, schedule):
    return {
        'staff_login': login,
        'schedule': schedule
    }


def get_login_to_schedule_list(env, oebs_api_client_id, oebs_api_tvm_secret, logins, date):
    result = []
    # It must be okay to pass all logins to the handler at once. However, for
    # some logins a error can occur in OEBS DB. In that case handler returns
    # nothing for all other logins as well. So, as a workaround many requests
    # are used.
    # (see https://st.yandex-team.ru/OEBSSUPPORT-57523)
    for login in logins:
        primary_assignments = oebs_api.primary_assignments(env, oebs_api_client_id, oebs_api_tvm_secret, [login], date)

        if 'logins' not in primary_assignments:
            print(f'Cannot retrieve information about login "{login}" from OEBS.', file=sys.stderr)
            result.append(_make_record(login, _SCHEDULE_UNKNOWN))
            continue

        result.append(
            _make_record(
                login,
                _get_schedule_type(login, primary_assignments['logins'][0])
            )
        )

    return result
