from maps.wikimap.stat.tasks_payment.reports.cartographic_report.lib.report import prepare_report

from nile.api.v1 import cli, statface
from yt.wrapper.ypath import ypath_join


_REPORT_PATH = 'Maps.Wiki/tasks_payment/Tasks_Payment'


@cli.statinfra_job()
def make_report(job, options, statface_client):
    for date in options.dates:
        prepare_report(
            job,
            date,
            # Logs
            job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs/assessment_log', date)),
            job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs/autocart_log', date)),
            job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs/feedback_log', date)),
            job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs/moderation_log', date)),
            job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs/mrc_pedestrian_log', date)),
            job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs/outsource_log', date)),
            job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs/tracker_log', date)),
            # Dictionaries
            major_regions_map=job.table('//home/maps/core/nmaps/analytics/geo-data/major_regions_map'),
            task_tariff_map=job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/task_tariff_map', date)),
            puid_map=job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/puid_map', date)),
            linked_accounts=job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/linked_accounts', date)),
            work_schedule=job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/work_schedule_daily', date)),
            user_holidays=job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/holidays', date)),
            basic_units=job.table('//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/basic_units'),
            staff_dump=job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/staff_dump', date)),
        ).publish(
            statface.StatfaceReport(
                path=_REPORT_PATH,
                scale=options.scale,
                client=statface_client
            )
        )

    return job


def main():
    cli.run()
