from maps.wikimap.stat.tasks_payment.tasks_logging.assessment.lib.assessment_log import make_log
from maps.wikimap.stat.tasks_payment.tasks_logging.libs.schema import CARTOGRAPHIC_TASKS_LOG_SCHEMA
from nile.api.v1 import cli
from yt.wrapper.ypath import ypath_join


@cli.statinfra_job()
def make_job(job, options):
    for date in options.dates:
        make_log(
            job,
            date,
            assessment_grade_table=job.table('//home/maps/core/nmaps/analytics/tasks_payment/replica/assessment_nmaps-14585/assessment_grade'),
            assessment_unit_table=job.table('//home/maps/core/nmaps/analytics/tasks_payment/replica/assessment_nmaps-14585/assessment_unit'),
            social_commit_event_table=job.table('//home/maps/core/nmaps/dynamic/replica/social/social_commit_event'),
            social_feedback_task_table=job.table('//home/maps/core/nmaps/analytics/feedback/db/feedback_latest'),
            social_task_table=job.concat(
                job.table('//home/maps/core/nmaps/dynamic/replica/social/social_task_active'),
                job.table('//home/maps/core/nmaps/dynamic/replica/social/social_task_closed'),
            ),
            issues_table=job.table('//home/startrek/tables/prod/yandex-team/queue/maps-pw/issues'),
            components_table=job.table('//home/startrek/tables/prod/yandex-team/queue/maps-pw/components'),
        ).put(
            ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs/assessment_log', date),
            schema=CARTOGRAPHIC_TASKS_LOG_SCHEMA,
            ensure_optional=False
        )

    return job


def main():
    cli.run()
