from maps.wikimap.stat.tasks_payment.tasks_logging.autocart.lib.autocart_log import make_log
from maps.wikimap.stat.tasks_payment.tasks_logging.libs.schema import CARTOGRAPHIC_TASKS_LOG_SCHEMA
from nile.api.v1 import cli
from yt.wrapper.ypath import ypath_join


@cli.statinfra_job()
def make_job(job, options):
    for date in options.dates:
        make_log(
            date,
            assessors_table=job.table('//home/maps/core/mrc/domovoi/storage/assessors'),
            nmaps_users_dump_log=job.table(ypath_join('//home/logfeller/logs/nmaps-users-dump-log/1d', date))
        ).put(
            ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs/autocart_log', date),
            schema=CARTOGRAPHIC_TASKS_LOG_SCHEMA,
            ensure_optional=False
        )

    return job


def main():
    cli.run()
