from maps.wikimap.stat.tasks_payment.tasks_logging.feedback.lib.feedback_log import make_feedback_log
from maps.wikimap.stat.tasks_payment.tasks_logging.libs.schema import CARTOGRAPHIC_TASKS_LOG_SCHEMA
from nile.api.v1 import cli
from yt.wrapper.ypath import ypath_join


@cli.statinfra_job()
def make_job(job, options):
    for date in options.dates:
        make_feedback_log(
            date,
            feedback=job.table('//home/maps/core/nmaps/analytics/feedback/db/feedback_latest'),
            social_commit_event=job.table('//home/maps/core/nmaps/dynamic/replica/social/social_commit_event')
        ).put(
            ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs/feedback_log', date),
            schema=CARTOGRAPHIC_TASKS_LOG_SCHEMA,
            ensure_optional=False
        )

    return job


def main():
    cli.run()
