from maps.wikimap.stat.tasks_payment.tasks_logging.moderation.lib.moderation_log import make_moderation_log_job
from nile.api.v1 import cli
from yt.wrapper.ypath import ypath_join

import logging


COMMIT_EVENT_PATH = '//home/maps/core/nmaps/dynamic/replica/social/social_commit_event'
MODERATION_LOG_DIR = '//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs/moderation_log'
TASK_ACTIVE_PATH = '//home/maps/core/nmaps/dynamic/replica/social/social_task_active'
TASK_CLOSED_PATH = '//home/maps/core/nmaps/dynamic/replica/social/social_task_closed'


@cli.statinfra_job()
def make_job(job, options):
    for date in options.dates:
        result_path = ypath_join(MODERATION_LOG_DIR, date)
        job = make_moderation_log_job(
            job,
            date=date,
            result_path=result_path,
            task_active_path=TASK_ACTIVE_PATH,
            task_closed_path=TASK_CLOSED_PATH,
            commit_event_path=COMMIT_EVENT_PATH
        )

    return job


def main():
    logging.basicConfig(
        level=logging.INFO,
        format='%(asctime)s %(message)s'
    )

    cli.run()
