Подсчёт лога модерации
======================
Каждую ночь по расписанию запускается [расчёт лога за предыдущий день][nirvana reaction]. Лог за некоторую дату содержит решённые (`resolved_at is not NULL`) или зыкрытые (`closed_at is not NULL`) в этот день задачи.


Алгоритм обработки решённых задач
---------------------------------
1. Из `social.task` выбираются задачи решённые в дату для которой производится расчёт.
2. Исключаются задачи, созданные для правок модераторов и других доверенных пользователей, которые автоматически отмечаются решёнными (`resolved_by == created_by`).
3. Исключаются задачи решённые по связям, для этого оставляется лишь одна задача из множества удовлетворяющих следующим требованиям:
   - решённые в один и тот же момент времени;
   - решённые одним и тем же пользователем; и
   - с одной и той же категорией (`primary_object_category_id`).

   Считается, что все такие задачи были переведны в состояние "решена" в результате одного действия модератора.
4. В `task_id` записывается `/moderation/resolved/<category_id>` для задач с известной категорией и `/moderation/resolved/common` в противном случае.


Алгоритм обработки закрытых задач
---------------------------------
1. Из `social.task` выбираются задачи закрытые в дату для которой производится расчёт.
2. Исключаются задачи, созданные для правок картографов и других доверенных пользователей, которые автоматически закрываются (`closed_by == created_by`).
3. Исключаются задачи закрытые автоматически. Так как в используемых источниках данных не различаются обычные и автоматически закрытые задачи, то считается, что задача была закрыта автоматически если:
   - у неё совпадает время решения и закрытия; и
   - она закрыта и решена одним и тем же пользователем.
4. Исключаются задачи закрытые по связям, для этого оставляется лишь одна задача из множества удовлетворяющих следующим требованиям:
   - закрытых в один и тот же момент времени;
   - закрытых одним и тем же пользователем; и
   - с одной и той же категорией (`primary_object_category_id`).

   Считается, что все такие задачи были закрыты в результате одного действия картографа.
4. В `task_id` записывается `/moderation/closed/<category_id>` для задач с известной категорией и `/moderation/closed/common` в противном случае.


[nirvana reaction]: https://beta.nirvana.yandex-team.ru/browse?selected=4063738
