from maps.wikimap.stat.tasks_payment.tasks_logging.mrc_pedestrian.lib.mrc_pedestrian_log import make_log
from maps.wikimap.stat.tasks_payment.tasks_logging.libs.schema import CARTOGRAPHIC_TASKS_LOG_SCHEMA
from nile.api.v1 import cli
from yt.wrapper.ypath import ypath_join


@cli.statinfra_job()
def make_job(job, options):
    for date in options.dates:
        make_log(
            date,
            signals_walk_object_replica=job.table('//home/maps/core/nmaps/dynamic/replica/mrc/signals_walk_object'),
            feedback_dump=job.table('//home/maps/core/nmaps/analytics/feedback/db/feedback_latest'),
            mrc_pedestrian_region_log=job.table('//home/maps/core/nmaps/analytics/logs/mrc-pedestrian-region-log'),
        ).put(
            ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs/mrc_pedestrian_log', date),
            schema=CARTOGRAPHIC_TASKS_LOG_SCHEMA,
            ensure_optional=False
        )

    return job


def main():
    cli.run()
