import maps.wikimap.stat.tasks_payment.tasks_logging.outsource.lib.outsource_log as osl
import maps.wikimap.stat.libs.common.lib.cli_options as cli_opts
from yt.wrapper import ypath_join


def eval_results_default(options):
    return ypath_join(options.analytics, osl.RESULTS_TABLES)


def define_options():
    return [
        cli_opts.logs_option(),
        cli_opts.analytics_option(),
        cli_opts.results_option(eval_results_default, 'analytics')
    ]


def make_job(job, options):
    return osl.make_job(
        job,
        isodate=cli_opts.get_single_date(options),
        logs_path=options.logs,
        results_path=cli_opts.get_results_path(options, eval_results_default)
    )
