from maps.wikimap.stat.libs.tracker import (
    filter_by_queues,
    convert_staff_uid_to_puid,
    get_closed_issues,
    get_tracker_task_id,
    check_issues,
)
from nile.api.v1 import extractors

_PAID_QUEUES = frozenset({'MAPSPW', 'FEEDBACKPW', 'OUTKARTPW'})


def _make_log(issues_with_puid):
    '''
    issues_with_puid:
    | puid | component | ticket | story_points | date |
    |------+-----------+--------+--------------+------|
    | ...  | ...       | ...    | ...          | ...  |

    Result:
    | iso_datetime | puid | task_id           | quantity | geom | lat_min | lon_min | lat_max | lon_max |
    |--------------+------+-------------------+----------+------+---------+---------+---------+---------|
    | date         | ...  | tracker/queue/... | ...      | ...  | ...     | ...     | ...     | ...     |
    '''
    return issues_with_puid.project(
        iso_datetime='date',
        puid='puid',
        task_id=extractors.custom(get_tracker_task_id, 'ticket', 'component'),
        quantity=extractors.custom(
            lambda story_points: story_points if story_points else 0.0,
            'story_points'
        ),
        geom=extractors.const(None),
        lat_min=extractors.const(None),
        lon_min=extractors.const(None),
        lat_max=extractors.const(None),
        lon_max=extractors.const(None)
    )


def make_tracker_cartographic_log(
    dates,
    linked_accounts,
    components_table,
    issue_events_table,
    issues_table,
    resolutions_table,
    statuses_table
):
    return get_closed_issues(
        dates,
        components_table,
        issue_events_table,
        filter_by_queues(issues_table, _PAID_QUEUES),
        resolutions_table,
        statuses_table
    ).map(
        check_issues
    ).call(
        convert_staff_uid_to_puid, linked_accounts
    ).call(
        _make_log
    )
