from maps.wikimap.stat.libs.nile_utils import put_tables_by_prefixes
from maps.wikimap.stat.tasks_payment.tasks_logging.libs.schema import GEOTEST_TASKS_LOG_SCHEMA
from maps.wikimap.stat.tasks_payment.tasks_logging.tracker.geotest_log.lib.geotest_log import make_tracker_geotest_log
from nile.api.v1 import cli


COMPONENTS_TABLE_PATH = '//home/startrek/tables/prod/yandex-team/queue/GEOTESTPW/components'
ISSUES_TABLE_PATH = '//home/startrek/tables/prod/yandex-team/queue/GEOTESTPW/issues'
ISSUE_EVENTS_TABLE_PATH = '//home/startrek/tables/prod/yandex-team/queue/GEOTESTPW/issue_events'
RESOLUTIONS_TABLE_PATH = '//home/startrek/tables/prod/yandex-team/common/resolutions'
STATUSES_TABLE_PATH = '//home/startrek/tables/prod/yandex-team/common/statuses'

TRACKER_GEOTEST_LOG_DIR = '//home/maps-qa/analytics/tasks_payment/tasks_logs/tracker_log'


@cli.statinfra_job()
def make_job(job, options):
    make_tracker_geotest_log(
        options.dates,
        job.table(COMPONENTS_TABLE_PATH),
        job.table(ISSUE_EVENTS_TABLE_PATH),
        job.table(ISSUES_TABLE_PATH),
        job.table(RESOLUTIONS_TABLE_PATH),
        job.table(STATUSES_TABLE_PATH),
    ).call(
        put_tables_by_prefixes,
        TRACKER_GEOTEST_LOG_DIR,
        'iso_datetime', options.dates,
        GEOTEST_TASKS_LOG_SCHEMA,
    )

    return job


def main():
    cli.run()
