from maps.wikimap.stat.libs.tracker import get_closed_issues, get_tracker_task_id
from nile.api.v1 import extractors


def _make_log(issues):
    '''
    issues:
    | staff_uid | component | ticket    | story_points | date |
    |-----------+-----------+-----------+--------------+------|
    | ...       | ...       | queue-... | ...          | ...  |

    Result:
    | iso_datetime | staff_uid | task_id                 | quantity     |
    |--------------+-----------+-------------------------+--------------|
    | date         | ...       | tracker/queue/component | story_points |
    '''
    return issues.project(
        'staff_uid',
        iso_datetime='date',
        task_id=extractors.custom(get_tracker_task_id, 'ticket', 'component'),
        quantity=extractors.custom(
            lambda story_points: story_points if story_points else 0.0,
            'story_points'
        )
    )


def make_tracker_geotest_log(
    dates,
    components_table,
    issue_events_table,
    issues_table,
    resolutions_table,
    statuses_table,
):
    return get_closed_issues(
        dates,
        components_table,
        issue_events_table,
        issues_table,
        resolutions_table,
        statuses_table,
    ).call(
        _make_log
    )
