#pragma once

#include <maps/wikimap/ugc/account/src/lib/paging.h>

#include <maps/wikimap/ugc/libs/common/types.h>
#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/geolib/include/bounding_box.h>
#include <yandex/maps/proto/ugc_account/assignment.pb.h>
#include <yandex/maps/proto/ugc_account/ugc_account.pb.h>
#include <pqxx/pqxx>

namespace maps::wiki::ugc::account {

namespace proto = yandex::maps::proto::ugc_account;

struct Assignment {
    AssignmentId id;
    Uid uid;
    AssignmentStatus status;
    std::map<std::string, proto::assignment::AssignmentMetadata> langToMetadata;
    maps::chrono::TimePoint updated;
    std::optional<geolib3::Point2> position;
};

pqxx::result loadAssignments(
    pqxx::transaction_base& txn,
    Uid uid,
    AssignmentStatus status,
    const std::set<MetadataId>& metadataIds);

pqxx::result loadAssignments(
    pqxx::transaction_base& txn,
    Uid uid,
    AssignmentStatus status,
    const std::set<MetadataId>& metadataIds,
    const geolib3::BoundingBox& bbox,
    size_t limit);

std::vector<Assignment> makeAssignments(
    pqxx::transaction_base& txn,
    const pqxx::result& rows,
    AssignmentStatus status,
    Uid uid);

std::vector<Assignment> getAssignmentsSlice(
    std::vector<Assignment> assignments,
    const Paging& paging);

proto::ugc_account::Assignments convertAssignments(
    const std::vector<Assignment>& assignments,
    const maps::locale::Locale& locale);

proto::ugc_account::Assignments findAssignments(
    pqxx::transaction_base& txn,
    Uid uid,
    AssignmentStatus status,
    const std::set<MetadataId>& metadataIds,
    const Paging& paging,
    const maps::locale::Locale& locale);

proto::ugc_account::Assignments findAssignments(
    pqxx::transaction_base& txn,
    Uid uid,
    AssignmentStatus status,
    const std::set<MetadataId>& metadataIds,
    const geolib3::BoundingBox& bbox,
    size_t limit,
    const maps::locale::Locale& locale);

void skipAssignment(
    pqxx::transaction_base& txn,
    Uid uid,
    const AssignmentId& assignmentId);

} // namespace maps::wiki::ugc::account
