#pragma once

#include <maps/wikimap/ugc/account/src/lib/paging.h>

#include <maps/wikimap/ugc/libs/common/types.h>
#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/locale/include/locale.h>
#include <yandex/maps/proto/ugc_account/contribution.pb.h>
#include <yandex/maps/proto/ugc_account/ugc_account.pb.h>
#include <pqxx/pqxx>

namespace maps::wiki::ugc::account {

namespace proto = yandex::maps::proto::ugc_account;

proto::contribution::ContributionMetadata getContributionMetadata(
    pqxx::transaction_base& txn,
    ContributionId id,
    Uid uid,
    const maps::locale::Locale& locale);

void appendContributions(
    pqxx::transaction_base& txn,
    proto::ugc_account::Contributions& contributions,
    Uid uid,
    const pqxx::result& rows,
    const maps::locale::Locale& locale);

proto::ugc_account::Contributions findContributions(
    pqxx::transaction_base& txn,
    Uid uid,
    const std::set<MetadataId>& metadataIds,
    const Paging& paging,
    const maps::locale::Locale& locale);

proto::ugc_account::ContributionsStat getContributionsStat(
    pqxx::transaction_base& txn,
    Uid uid,
    const std::set<MetadataId>& metadataIds);

} // namespace maps::wiki::ugc::account
